/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.driver.mongodb.sync.v4.repository;

import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.client.MongoCollection;
import io.mongock.api.exception.MongockException;
import io.mongock.driver.api.entry.ChangeEntryService;
import io.mongock.driver.mongodb.sync.v4.MongoDbSync4DriverTestAdapterImpl;
import io.mongock.driver.mongodb.sync.v4.repository.MongoSync4ChangeEntryRepository;
import io.mongock.driver.mongodb.sync.v4.repository.MongoSync4LockRepository;
import io.mongock.driver.mongodb.sync.v4.repository.MongoSync4RepositoryBase;
import io.mongock.driver.mongodb.sync.v4.repository.ReadWriteConfiguration;
import io.mongock.driver.mongodb.sync.v4.repository.util.RepositoryAccessorHelper;
import io.mongock.driver.mongodb.test.template.MongoChangeEntryRepositoryITestBase;
import io.mongock.driver.mongodb.test.template.util.MongoDBDriverTestAdapter;
import org.bson.Document;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class MongoSync4ChangeEntryRepositoryITest
extends MongoChangeEntryRepositoryITestBase {
    protected void initializeRepository(boolean indexCreation) {
        MongoSync4ChangeEntryRepository repo = new MongoSync4ChangeEntryRepository(this.getDataBase().getCollection("mongockChangeLog"));
        repo.setIndexCreation(indexCreation);
        this.repository = (ChangeEntryService)Mockito.spy((Object)repo);
        this.repository.initialize();
    }

    @Test
    public void shouldCreateUniqueIndex_whenEnsureIndex_IfNotCreatedYet() throws MongockException {
        this.initializeRepository(true);
        ((MongoSync4ChangeEntryRepository)Mockito.verify((Object)((MongoSync4ChangeEntryRepository)this.repository), (VerificationMode)Mockito.times((int)1))).createRequiredUniqueIndex();
        ((MongoSync4ChangeEntryRepository)Mockito.verify((Object)((MongoSync4ChangeEntryRepository)this.repository), (VerificationMode)Mockito.times((int)0))).dropIndex((Document)Matchers.any(Document.class));
    }

    @Test
    public void shouldNoCreateUniqueIndex_whenEnsureIndex_IfAlreadyCreated() throws MongockException {
        this.initializeRepository(true);
        this.repository = (ChangeEntryService)Mockito.spy((Object)new MongoSync4ChangeEntryRepository(this.getDataBase().getCollection("mongockChangeLog")));
        ((MongoSync4ChangeEntryRepository)Mockito.doReturn((Object)true).when((Object)((MongoSync4ChangeEntryRepository)this.repository))).isUniqueIndex((Document)Matchers.any(Document.class));
        this.repository.initialize();
        ((MongoSync4ChangeEntryRepository)Mockito.verify((Object)((MongoSync4ChangeEntryRepository)this.repository), (VerificationMode)Mockito.times((int)0))).createRequiredUniqueIndex();
        ((MongoSync4ChangeEntryRepository)Mockito.verify((Object)((MongoSync4ChangeEntryRepository)this.repository), (VerificationMode)Mockito.times((int)0))).dropIndex(new Document());
    }

    @Test
    public void shouldCreateDefaultReadWriteConcerns_whenCreating_ifNoParams() {
        this.testReadWriteConcern(WriteConcern.MAJORITY.withJournal(Boolean.valueOf(true)), ReadConcern.MAJORITY, ReadPreference.primary(), null);
    }

    @Test
    public void shouldPassedReadWriteConcerns_whenCreating_ifConfigurationIsPassed() {
        WriteConcern expectedWriteConcern = WriteConcern.W1;
        ReadConcern expectedReadConcern = ReadConcern.LINEARIZABLE;
        ReadPreference expectedReadPreference = ReadPreference.nearest();
        ReadWriteConfiguration readWriteConfiguration = new ReadWriteConfiguration(expectedWriteConcern, expectedReadConcern, expectedReadPreference);
        this.testReadWriteConcern(expectedWriteConcern, expectedReadConcern, expectedReadPreference, readWriteConfiguration);
    }

    private void testReadWriteConcern(WriteConcern expectedWriteConcern, ReadConcern expectedReadConcern, ReadPreference expectedReadPreference, ReadWriteConfiguration readWriteConfiguration) {
        MongoSync4LockRepository repo;
        if (readWriteConfiguration != null) {
            repo = new MongoSync4LockRepository(this.getDataBase().getCollection("mongockLock"), readWriteConfiguration);
            repo.setIndexCreation(true);
        } else {
            repo = new MongoSync4LockRepository(this.getDataBase().getCollection("mongockLock"));
            repo.setIndexCreation(true);
        }
        MongoCollection collection = RepositoryAccessorHelper.getCollection((MongoSync4RepositoryBase)repo);
        Assert.assertEquals((Object)expectedWriteConcern, (Object)collection.getWriteConcern());
        Assert.assertEquals((Object)expectedReadConcern, (Object)collection.getReadConcern());
        Assert.assertEquals((Object)expectedReadPreference, (Object)collection.getReadPreference());
    }

    protected MongoDBDriverTestAdapter getAdapter(String collectionName) {
        return new MongoDbSync4DriverTestAdapterImpl((MongoCollection<Document>)this.getDataBase().getCollection(collectionName));
    }
}

