/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.driver.mongodb.sync.v4.repository;

import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.client.MongoCollection;
import io.mongock.api.exception.MongockException;
import io.mongock.driver.core.lock.LockRepositoryWithEntity;
import io.mongock.driver.mongodb.sync.v4.MongoDbSync4DriverTestAdapterImpl;
import io.mongock.driver.mongodb.sync.v4.repository.MongoSync4LockRepository;
import io.mongock.driver.mongodb.sync.v4.repository.MongoSync4RepositoryBase;
import io.mongock.driver.mongodb.sync.v4.repository.ReadWriteConfiguration;
import io.mongock.driver.mongodb.sync.v4.repository.util.RepositoryAccessorHelper;
import io.mongock.driver.mongodb.test.template.MongoLockRepositoryITestBase;
import io.mongock.driver.mongodb.test.template.util.MongoDBDriverTestAdapter;
import org.bson.Document;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class MongoSync4LockRepositoryITest
extends MongoLockRepositoryITestBase {
    private static final String LOCK_COLLECTION_NAME = "mongockLock";

    @Test
    public void shouldCreateUniqueIndex_whenEnsureIndex_IfNotCreatedYet() throws MongockException {
        this.initializeRepository();
        ((MongoSync4LockRepository)Mockito.verify((Object)((MongoSync4LockRepository)this.repository), (VerificationMode)Mockito.times((int)1))).createRequiredUniqueIndex();
        ((MongoSync4LockRepository)Mockito.verify((Object)((MongoSync4LockRepository)this.repository), (VerificationMode)Mockito.times((int)0))).dropIndex((Document)ArgumentMatchers.any(Document.class));
    }

    @Test
    public void shouldNoCreateUniqueIndex_whenEnsureIndex_IfAlreadyCreated() throws MongockException {
        this.initializeRepository();
        MongoSync4LockRepository repo = new MongoSync4LockRepository(this.getDataBase().getCollection(LOCK_COLLECTION_NAME));
        repo.setIndexCreation(true);
        this.repository = (LockRepositoryWithEntity)Mockito.spy((Object)repo);
        ((MongoSync4LockRepository)Mockito.doReturn((Object)true).when((Object)((MongoSync4LockRepository)this.repository))).isUniqueIndex((Document)ArgumentMatchers.any(Document.class));
        this.repository.initialize();
        ((MongoSync4LockRepository)Mockito.verify((Object)((MongoSync4LockRepository)this.repository), (VerificationMode)Mockito.times((int)0))).createRequiredUniqueIndex();
        ((MongoSync4LockRepository)Mockito.verify((Object)((MongoSync4LockRepository)this.repository), (VerificationMode)Mockito.times((int)0))).dropIndex(new Document());
    }

    @Test
    public void shouldCreateDefaultReadWriteConcerns_whenCreating_ifNoParams() {
        this.testReadWriteConcern(WriteConcern.MAJORITY.withJournal(Boolean.valueOf(true)), ReadConcern.MAJORITY, ReadPreference.primary(), null);
    }

    @Test
    public void shouldPassedReadWriteConcerns_whenCreating_ifConfigurationIsPassed() {
        WriteConcern expectedWriteConcern = WriteConcern.W1;
        ReadConcern expectedReadConcern = ReadConcern.LINEARIZABLE;
        ReadPreference expectedReadPreference = ReadPreference.nearest();
        ReadWriteConfiguration readWriteConfiguration = new ReadWriteConfiguration(expectedWriteConcern, expectedReadConcern, expectedReadPreference);
        this.testReadWriteConcern(expectedWriteConcern, expectedReadConcern, expectedReadPreference, readWriteConfiguration);
    }

    private void testReadWriteConcern(WriteConcern expectedWriteConcern, ReadConcern expectedReadConcern, ReadPreference expectedReadPreference, ReadWriteConfiguration readWriteConfiguration) {
        MongoSync4LockRepository repo = readWriteConfiguration != null ? new MongoSync4LockRepository(this.getDataBase().getCollection(LOCK_COLLECTION_NAME), readWriteConfiguration) : new MongoSync4LockRepository(this.getDataBase().getCollection(LOCK_COLLECTION_NAME));
        MongoCollection collection = RepositoryAccessorHelper.getCollection((MongoSync4RepositoryBase)repo);
        Assert.assertEquals((Object)expectedWriteConcern, (Object)collection.getWriteConcern());
        Assert.assertEquals((Object)expectedReadConcern, (Object)collection.getReadConcern());
        Assert.assertEquals((Object)expectedReadPreference, (Object)collection.getReadPreference());
    }

    protected void initializeRepository() {
        MongoSync4LockRepository repo = new MongoSync4LockRepository(this.getDataBase().getCollection(LOCK_COLLECTION_NAME));
        repo.setIndexCreation(true);
        this.repository = (LockRepositoryWithEntity)Mockito.spy((Object)repo);
        this.repository.initialize();
    }

    protected MongoDBDriverTestAdapter getAdapter(String collectionName) {
        return new MongoDbSync4DriverTestAdapterImpl((MongoCollection<Document>)this.getDataBase().getCollection(collectionName));
    }
}

