/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.driver.mongodb.sync.v4.driver;

import com.mongodb.client.MongoClient;
import io.mongock.driver.mongodb.sync.v4.driver.MongoSync4DriverBase;
import io.mongock.utils.Constants;
import io.mongock.utils.TimeService;
import io.mongock.utils.annotation.NotThreadSafe;

@NotThreadSafe
public class MongoSync4Driver
extends MongoSync4DriverBase {
    protected MongoSync4Driver(MongoClient mongoClient, String databaseName, long lockAcquiredForMillis, long lockQuitTryingAfterMillis, long lockTryFrequencyMillis) {
        super(mongoClient, databaseName, lockAcquiredForMillis, lockQuitTryingAfterMillis, lockTryFrequencyMillis);
    }

    public static MongoSync4Driver withDefaultLock(MongoClient mongoClient, String databaseName) {
        return MongoSync4Driver.withLockStrategy(mongoClient, databaseName, Constants.DEFAULT_LOCK_ACQUIRED_FOR_MILLIS, Constants.DEFAULT_QUIT_TRYING_AFTER_MILLIS, Constants.DEFAULT_TRY_FREQUENCY_MILLIS);
    }

    public static MongoSync4Driver withLockStrategy(MongoClient mongoClient, String databaseName, long lockAcquiredForMillis, long lockQuitTryingAfterMillis, long lockTryFrequencyMillis) {
        return new MongoSync4Driver(mongoClient, databaseName, lockAcquiredForMillis, lockQuitTryingAfterMillis, lockTryFrequencyMillis);
    }

    @Deprecated
    public static MongoSync4Driver withLockSetting(MongoClient mongoClient, String databaseName, long lockAcquiredForMinutes, long maxWaitingForLockMinutes, int maxTries) {
        TimeService timeService = new TimeService();
        long lockAcquiredForMillis = timeService.minutesToMillis(lockAcquiredForMinutes);
        long lockQuitTryingAfterMillis = timeService.minutesToMillis(maxWaitingForLockMinutes * (long)maxTries);
        long tryFrequency = 1000L;
        return MongoSync4Driver.withLockStrategy(mongoClient, databaseName, lockAcquiredForMillis, lockQuitTryingAfterMillis, tryFrequency);
    }
}

