/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.driver.mongodb.sync.v4.driver;

import com.mongodb.MongoClientException;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.TransactionBody;
import io.mongock.api.exception.MongockException;
import io.mongock.driver.api.driver.ChangeSetDependency;
import io.mongock.driver.api.driver.Transactional;
import io.mongock.driver.mongodb.sync.v4.driver.MongoSync4DriverGeneric;
import io.mongock.utils.annotation.NotThreadSafe;
import java.util.Optional;
import java.util.Set;

@NotThreadSafe
public abstract class MongoSync4DriverBase
extends MongoSync4DriverGeneric {
    private final MongoClient mongoClient;
    private final String databaseName;
    protected ClientSession clientSession;

    protected MongoSync4DriverBase(MongoClient mongoClient, String databaseName, long lockAcquiredForMillis, long lockQuitTryingAfterMillis, long lockTryFrequencyMillis) {
        super(lockAcquiredForMillis, lockQuitTryingAfterMillis, lockTryFrequencyMillis);
        this.mongoClient = mongoClient;
        this.databaseName = databaseName;
    }

    @Override
    protected MongoDatabase getDataBase() {
        return this.mongoClient.getDatabase(this.databaseName);
    }

    public void prepareForExecutionBlock() {
        try {
            this.clientSession = this.mongoClient.startSession();
        }
        catch (MongoClientException ex) {
            throw new MongockException("ERROR starting session. If Mongock is connected to a MongoDB cluster which doesn't support transactions, you must to disable transactions", (Exception)((Object)ex));
        }
    }

    public Set<ChangeSetDependency> getDependencies() {
        Set dependencies = super.getDependencies();
        if (this.clientSession != null) {
            ChangeSetDependency clientSessionDependency = new ChangeSetDependency(ClientSession.class, (Object)this.clientSession, false);
            dependencies.remove(clientSessionDependency);
            dependencies.add(clientSessionDependency);
        }
        return dependencies;
    }

    public void executeInTransaction(Runnable operation) {
        try {
            this.changeEntryRepository.setClientSession(this.clientSession);
            this.clientSession.withTransaction(this.getTransactionBody(operation), this.txOptions);
        }
        catch (Exception ex) {
            throw new MongockException((Throwable)ex);
        }
        finally {
            this.changeEntryRepository.clearClientSession();
            this.clientSession.close();
        }
    }

    private TransactionBody<String> getTransactionBody(Runnable operation) {
        return () -> {
            operation.run();
            return "Mongock transaction operation";
        };
    }

    public Optional<Transactional> getTransactioner() {
        return Optional.ofNullable(this.transactionEnabled ? this : null);
    }
}

