/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.driver.mongodb.v3.repository;

import com.mongodb.client.MongoCollection;
import io.mongock.api.exception.MongockException;
import io.mongock.driver.core.lock.LockRepositoryWithEntity;
import io.mongock.driver.mongodb.test.template.MongoLockRepositoryITestBase;
import io.mongock.driver.mongodb.test.template.util.MongoDBDriverTestAdapter;
import io.mongock.driver.mongodb.v3.MongoDb3DriverTestAdapterImpl;
import io.mongock.driver.mongodb.v3.repository.Mongo3LockRepository;
import org.bson.Document;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class Mongo3LockRepositoryITest
extends MongoLockRepositoryITestBase {
    private static final String LOCK_COLLECTION_NAME = "mongockLock";

    @Test
    public void shouldCreateUniqueIndex_whenEnsureIndex_IfNotCreatedYet() throws MongockException {
        this.initializeRepository();
        ((Mongo3LockRepository)Mockito.verify((Object)((Mongo3LockRepository)this.repository), (VerificationMode)Mockito.times((int)1))).createRequiredUniqueIndex();
        ((Mongo3LockRepository)Mockito.verify((Object)((Mongo3LockRepository)this.repository), (VerificationMode)Mockito.times((int)0))).dropIndex((Document)ArgumentMatchers.any(Document.class));
    }

    @Test
    public void shouldNoCreateUniqueIndex_whenEnsureIndex_IfAlreadyCreated() throws MongockException {
        this.initializeRepository();
        this.repository = (LockRepositoryWithEntity)Mockito.spy((Object)new Mongo3LockRepository(this.getDataBase().getCollection(LOCK_COLLECTION_NAME), true));
        ((Mongo3LockRepository)Mockito.doReturn((Object)true).when((Object)((Mongo3LockRepository)this.repository))).isUniqueIndex((Document)ArgumentMatchers.any(Document.class));
        this.repository.initialize();
        ((Mongo3LockRepository)Mockito.verify((Object)((Mongo3LockRepository)this.repository), (VerificationMode)Mockito.times((int)0))).createRequiredUniqueIndex();
        ((Mongo3LockRepository)Mockito.verify((Object)((Mongo3LockRepository)this.repository), (VerificationMode)Mockito.times((int)0))).dropIndex(new Document());
    }

    protected void initializeRepository() {
        Mongo3LockRepository repo = new Mongo3LockRepository(this.getDataBase().getCollection(LOCK_COLLECTION_NAME), true);
        repo.setIndexCreation(true);
        this.repository = (LockRepositoryWithEntity)Mockito.spy((Object)repo);
        this.repository.initialize();
    }

    protected MongoDBDriverTestAdapter getAdapter(String collectionName) {
        return new MongoDb3DriverTestAdapterImpl((MongoCollection<Document>)this.getDataBase().getCollection(collectionName));
    }
}

