/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.driver.mongodb.v3.driver;

import com.mongodb.client.MongoClient;
import io.mongock.driver.mongodb.v3.driver.MongoCore3DriverBase;
import io.mongock.utils.TimeService;
import io.mongock.utils.annotation.NotThreadSafe;

@NotThreadSafe
public class MongoCore3Driver
extends MongoCore3DriverBase {
    protected MongoCore3Driver(MongoClient mongoClient, String databaseName, long lockAcquiredForMillis, long lockQuitTryingAfterMillis, long lockTryFrequencyMillis) {
        super(mongoClient, databaseName, lockAcquiredForMillis, lockQuitTryingAfterMillis, lockTryFrequencyMillis);
    }

    public static MongoCore3Driver withDefaultLock(MongoClient mongoClient, String databaseName) {
        return MongoCore3Driver.withLockStrategy(mongoClient, databaseName, 60000L, 180000L, 1000L);
    }

    public static MongoCore3Driver withLockStrategy(MongoClient mongoClient, String databaseName, long lockAcquiredForMillis, long lockQuitTryingAfterMillis, long lockTryFrequencyMillis) {
        return new MongoCore3Driver(mongoClient, databaseName, lockAcquiredForMillis, lockQuitTryingAfterMillis, lockTryFrequencyMillis);
    }

    @Deprecated
    public static MongoCore3Driver withLockSetting(MongoClient mongoClient, String databaseName, long lockAcquiredForMinutes, long maxWaitingForLockMinutes, int maxTries) {
        TimeService timeService = new TimeService();
        long lockAcquiredForMillis = timeService.minutesToMillis(lockAcquiredForMinutes);
        long lockQuitTryingAfterMillis = timeService.minutesToMillis(maxWaitingForLockMinutes * (long)maxTries);
        long tryFrequency = 1000L;
        return MongoCore3Driver.withLockStrategy(mongoClient, databaseName, lockAcquiredForMillis, lockQuitTryingAfterMillis, tryFrequency);
    }
}

