/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.driver.mongodb.v3.driver;

import com.mongodb.MongoClientException;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoClient;
import com.mongodb.client.TransactionBody;
import io.mongock.api.exception.MongockException;
import io.mongock.driver.api.driver.ChangeSetDependency;
import io.mongock.driver.api.driver.Transactioner;
import io.mongock.driver.mongodb.v3.driver.MongoCore3DriverGeneric;
import io.mongock.utils.annotation.NotThreadSafe;
import java.util.Optional;
import java.util.Set;

@NotThreadSafe
public abstract class MongoCore3DriverBase
extends MongoCore3DriverGeneric {
    private final MongoClient mongoClient;
    protected ClientSession clientSession;
    private boolean transactionEnabled = true;

    protected MongoCore3DriverBase(MongoClient mongoClient, String databaseName, long lockAcquiredForMillis, long lockQuitTryingAfterMillis, long lockTryFrequencyMillis) {
        super(mongoClient.getDatabase(databaseName), lockAcquiredForMillis, lockQuitTryingAfterMillis, lockTryFrequencyMillis);
        this.mongoClient = mongoClient;
    }

    public void prepareForExecutionBlock() {
        try {
            this.clientSession = this.mongoClient.startSession();
        }
        catch (MongoClientException ex) {
            throw new MongockException("ERROR starting session. If Mongock is connected to a MongoDB cluster which doesn't support transactions, you must to disable transactions", (Exception)((Object)ex));
        }
    }

    @Override
    public Set<ChangeSetDependency> getDependencies() {
        Set<ChangeSetDependency> dependencies = super.getDependencies();
        if (this.clientSession != null) {
            ChangeSetDependency clientSessionDependency = new ChangeSetDependency(ClientSession.class, (Object)this.clientSession, false);
            dependencies.remove(clientSessionDependency);
            dependencies.add(clientSessionDependency);
        }
        return dependencies;
    }

    public void executeInTransaction(Runnable operation) {
        try {
            this.changeEntryRepository.setClientSession(this.clientSession);
            this.clientSession.withTransaction(this.getTransactionBody(operation), this.txOptions);
        }
        catch (Exception ex) {
            throw new MongockException((Throwable)ex);
        }
        finally {
            this.changeEntryRepository.clearClientSession();
            this.clientSession.close();
        }
    }

    private TransactionBody<String> getTransactionBody(Runnable operation) {
        return () -> {
            operation.run();
            return "Mongock transaction operation";
        };
    }

    public void disableTransaction() {
        this.transactionEnabled = false;
    }

    public Optional<Transactioner> getTransactioner() {
        return Optional.ofNullable(this.transactionEnabled ? this : null);
    }
}

