/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.driver.mongodb.v3.repository;

import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Accumulators;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.BsonField;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.Sorts;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.result.UpdateResult;
import io.mongock.api.exception.MongockException;
import io.mongock.driver.api.entry.ChangeEntry;
import io.mongock.driver.api.entry.ChangeState;
import io.mongock.driver.api.entry.ChangeType;
import io.mongock.driver.api.entry.ExecutedChangeEntry;
import io.mongock.driver.core.entry.ChangeEntryRepositoryWithEntity;
import io.mongock.driver.mongodb.v3.repository.Mongo3RepositoryBase;
import io.mongock.driver.mongodb.v3.repository.ReadWriteConfiguration;
import io.mongock.utils.field.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.conversions.Bson;

public class Mongo3ChangeEntryRepository
extends Mongo3RepositoryBase<ChangeEntry>
implements ChangeEntryRepositoryWithEntity<Document> {
    protected static String KEY_EXECUTION_ID;
    protected static String KEY_CHANGE_ID;
    protected static String KEY_STATE;
    protected static String KEY_TYPE;
    protected static String KEY_AUTHOR;
    protected static String KEY_TIMESTAMP;
    protected static String KEY_CHANGELOG_CLASS;
    protected static String KEY_CHANGESET_METHOD;
    protected static String KEY_EXECUTION_MILLIS;
    protected static String KEY_EXECUTION_HOSTNAME;
    protected static String KEY_METADATA;
    private ClientSession clientSession;

    public Mongo3ChangeEntryRepository(MongoCollection<Document> collection) {
        this(collection, ReadWriteConfiguration.getDefault());
    }

    public Mongo3ChangeEntryRepository(MongoCollection<Document> collection, ReadWriteConfiguration readWriteConfiguration) {
        super(collection, new String[]{KEY_EXECUTION_ID, KEY_AUTHOR, KEY_CHANGE_ID}, readWriteConfiguration);
    }

    public boolean isAlreadyExecuted(String changeSetId, String author) throws MongockException {
        Document entry = (Document)this.collection.find(this.buildSearchQueryDBObject(changeSetId, author)).sort(Sorts.descending((String[])new String[]{KEY_TIMESTAMP})).first();
        if (entry != null && !entry.isEmpty()) {
            String entryState = entry.getString((Object)KEY_STATE);
            return entryState == null || entryState.isEmpty() || entryState.equals(ChangeState.EXECUTED.name());
        }
        return false;
    }

    public List<ExecutedChangeEntry> getExecuted() throws MongockException {
        Bson matchExecutedOrRolledBack = Aggregates.match((Bson)Filters.or((Bson[])new Bson[]{Filters.eq((String)KEY_STATE, (Object)ChangeState.EXECUTED.name()), Filters.eq((String)KEY_STATE, (Object)ChangeState.ROLLED_BACK.name()), Filters.eq((String)KEY_STATE, null), Filters.exists((String)KEY_STATE, (boolean)false)}));
        Bson previousSort = Aggregates.sort((Bson)Sorts.descending((String[])new String[]{KEY_TIMESTAMP}));
        Bson group = Aggregates.group((Object)Projections.fields((Bson[])new Bson[]{Filters.eq((String)KEY_CHANGE_ID, (Object)("$" + KEY_CHANGE_ID)), Filters.eq((String)KEY_AUTHOR, (Object)("$" + KEY_AUTHOR))}), (BsonField[])new BsonField[]{Accumulators.first((String)KEY_CHANGE_ID, (Object)("$" + KEY_CHANGE_ID)), Accumulators.first((String)KEY_AUTHOR, (Object)("$" + KEY_AUTHOR)), Accumulators.first((String)KEY_STATE, (Object)("$" + KEY_STATE)), Accumulators.first((String)KEY_TIMESTAMP, (Object)("$" + KEY_TIMESTAMP)), Accumulators.first((String)KEY_CHANGELOG_CLASS, (Object)("$" + KEY_CHANGELOG_CLASS)), Accumulators.first((String)KEY_CHANGESET_METHOD, (Object)("$" + KEY_CHANGESET_METHOD))});
        Bson projection = Aggregates.project((Bson)Projections.fields((Bson[])new Bson[]{Projections.include((String[])new String[]{KEY_CHANGE_ID, KEY_AUTHOR, KEY_STATE, KEY_TIMESTAMP, KEY_CHANGELOG_CLASS, KEY_CHANGESET_METHOD}), Projections.excludeId()}));
        Bson finalSort = Aggregates.sort((Bson)Sorts.ascending((String[])new String[]{KEY_TIMESTAMP}));
        Bson matchOnlyExecuted = Aggregates.match((Bson)Filters.or((Bson[])new Bson[]{Filters.eq((String)KEY_STATE, (Object)ChangeState.EXECUTED.name()), Filters.eq((String)KEY_STATE, null), Filters.exists((String)KEY_STATE, (boolean)false)}));
        return ((ArrayList)this.collection.aggregate(Arrays.asList(matchExecutedOrRolledBack, previousSort, group, projection, matchOnlyExecuted, finalSort)).into(new ArrayList())).stream().map(entry -> new ExecutedChangeEntry(entry.getString((Object)KEY_CHANGE_ID), entry.getString((Object)KEY_AUTHOR), entry.getDate((Object)KEY_TIMESTAMP), entry.getString((Object)KEY_CHANGELOG_CLASS), entry.getString((Object)KEY_CHANGESET_METHOD))).collect(Collectors.toList());
    }

    public List<ChangeEntry> getEntriesLog() {
        return ((ArrayList)this.collection.find().into(new ArrayList())).stream().map(entry -> new ChangeEntry(entry.getString((Object)KEY_EXECUTION_ID), entry.getString((Object)KEY_CHANGE_ID), entry.getString((Object)KEY_AUTHOR), entry.getDate((Object)KEY_TIMESTAMP), entry.getString((Object)KEY_STATE) != null ? ChangeState.valueOf((String)entry.getString((Object)KEY_STATE)) : null, entry.getString((Object)KEY_TYPE) != null ? ChangeType.valueOf((String)entry.getString((Object)KEY_TYPE)) : null, entry.getString((Object)KEY_CHANGELOG_CLASS), entry.getString((Object)KEY_CHANGESET_METHOD), entry.getLong((Object)KEY_EXECUTION_MILLIS).longValue(), entry.getString((Object)KEY_EXECUTION_HOSTNAME), entry.get((Object)KEY_METADATA))).collect(Collectors.toList());
    }

    public void setClientSession(ClientSession clientSession) {
        this.clientSession = clientSession;
    }

    public void clearClientSession() {
        this.setClientSession(null);
    }

    private Optional<ClientSession> getClientSession() {
        return Optional.ofNullable(this.clientSession);
    }

    public void saveOrUpdate(ChangeEntry changeEntry) throws MongockException {
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)KEY_EXECUTION_ID, (Object)changeEntry.getExecutionId()), Filters.eq((String)KEY_CHANGE_ID, (Object)changeEntry.getChangeId()), Filters.eq((String)KEY_AUTHOR, (Object)changeEntry.getAuthor())});
        Document document = (Document)this.collection.find(filter).first();
        if (document != null) {
            ((Document)this.toEntity(changeEntry)).forEach((arg_0, arg_1) -> ((Document)document).put(arg_0, arg_1));
            UpdateResult updateResult = this.getClientSession().map(clientSession -> this.collection.updateOne(clientSession, filter, (Bson)new Document("$set", (Object)document), new UpdateOptions().upsert(true))).orElseGet(() -> this.collection.updateOne(filter, (Bson)new Document("$set", (Object)document), new UpdateOptions().upsert(true)));
        } else if (this.getClientSession().isPresent()) {
            this.collection.insertOne(this.getClientSession().get(), this.toEntity(changeEntry));
        } else {
            this.collection.insertOne(this.toEntity(changeEntry));
        }
    }

    protected Bson buildSearchQueryDBObject(String changeSetId, String author) {
        Bson executedStateOrNoExisting = Filters.or((Bson[])new Bson[]{Filters.eq((String)KEY_STATE, (Object)ChangeState.EXECUTED.name()), Filters.eq((String)KEY_STATE, (Object)ChangeState.ROLLED_BACK.name()), Filters.eq((String)KEY_STATE, null), Filters.exists((String)KEY_STATE, (boolean)false)});
        return Filters.and((Bson[])new Bson[]{Filters.eq((String)KEY_CHANGE_ID, (Object)changeSetId), Filters.eq((String)KEY_AUTHOR, (Object)author), executedStateOrNoExisting});
    }

    static {
        try {
            java.lang.reflect.Field field = ChangeEntry.class.getDeclaredField("executionId");
            field.setAccessible(true);
            KEY_EXECUTION_ID = field.getAnnotation(Field.class).value();
            field = ChangeEntry.class.getDeclaredField("changeId");
            field.setAccessible(true);
            KEY_CHANGE_ID = field.getAnnotation(Field.class).value();
            field = ChangeEntry.class.getDeclaredField("state");
            field.setAccessible(true);
            KEY_STATE = field.getAnnotation(Field.class).value();
            field = ChangeEntry.class.getDeclaredField("type");
            field.setAccessible(true);
            KEY_TYPE = field.getAnnotation(Field.class).value();
            field = ChangeEntry.class.getDeclaredField("author");
            field.setAccessible(true);
            KEY_AUTHOR = field.getAnnotation(Field.class).value();
            field = ChangeEntry.class.getDeclaredField("timestamp");
            field.setAccessible(true);
            KEY_TIMESTAMP = field.getAnnotation(Field.class).value();
            field = ChangeEntry.class.getDeclaredField("changeLogClass");
            field.setAccessible(true);
            KEY_CHANGELOG_CLASS = field.getAnnotation(Field.class).value();
            field = ChangeEntry.class.getDeclaredField("changeSetMethod");
            field.setAccessible(true);
            KEY_CHANGESET_METHOD = field.getAnnotation(Field.class).value();
            field = ChangeEntry.class.getDeclaredField("metadata");
            field.setAccessible(true);
            KEY_METADATA = field.getAnnotation(Field.class).value();
            field = ChangeEntry.class.getDeclaredField("executionMillis");
            field.setAccessible(true);
            KEY_EXECUTION_MILLIS = field.getAnnotation(Field.class).value();
            field = ChangeEntry.class.getDeclaredField("executionHostname");
            field.setAccessible(true);
            KEY_EXECUTION_HOSTNAME = field.getAnnotation(Field.class).value();
        }
        catch (NoSuchFieldException e) {
            throw new MongockException((Throwable)e);
        }
    }
}

