/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.driver.mongodb.v3.repository;

import com.mongodb.client.MongoCollection;
import io.mongock.api.exception.MongockException;
import io.mongock.driver.api.entry.ChangeEntryService;
import io.mongock.driver.mongodb.test.template.MongoChangeEntryRepositoryITestBase;
import io.mongock.driver.mongodb.test.template.util.MongoDBDriverTestAdapter;
import io.mongock.driver.mongodb.v3.MongoDb3DriverTestAdapterImpl;
import io.mongock.driver.mongodb.v3.repository.Mongo3ChangeEntryRepository;
import org.bson.Document;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class Mongo3ChangeEntryRepositoryITest
extends MongoChangeEntryRepositoryITestBase {
    protected void initializeRepository(boolean indexCreation) {
        Mongo3ChangeEntryRepository repo = new Mongo3ChangeEntryRepository(this.getDataBase().getCollection("mongockChangeLog"));
        repo.setIndexCreation(indexCreation);
        this.repository = (ChangeEntryService)Mockito.spy((Object)repo);
        this.repository.initialize();
    }

    @Test
    public void shouldCreateUniqueIndex_whenEnsureIndex_IfNotCreatedYet() throws MongockException {
        this.initializeRepository(true);
        ((Mongo3ChangeEntryRepository)Mockito.verify((Object)((Mongo3ChangeEntryRepository)this.repository), (VerificationMode)Mockito.times((int)1))).createRequiredUniqueIndex();
        ((Mongo3ChangeEntryRepository)Mockito.verify((Object)((Mongo3ChangeEntryRepository)this.repository), (VerificationMode)Mockito.times((int)0))).dropIndex((Document)Matchers.any(Document.class));
    }

    @Test
    public void shouldNoCreateUniqueIndex_whenEnsureIndex_IfAlreadyCreated() throws MongockException {
        this.initializeRepository(true);
        this.repository = (ChangeEntryService)Mockito.spy((Object)new Mongo3ChangeEntryRepository(this.getDataBase().getCollection("mongockChangeLog")));
        ((Mongo3ChangeEntryRepository)Mockito.doReturn((Object)true).when((Object)((Mongo3ChangeEntryRepository)this.repository))).isUniqueIndex((Document)Matchers.any(Document.class));
        this.repository.initialize();
        ((Mongo3ChangeEntryRepository)Mockito.verify((Object)((Mongo3ChangeEntryRepository)this.repository), (VerificationMode)Mockito.times((int)0))).createRequiredUniqueIndex();
        ((Mongo3ChangeEntryRepository)Mockito.verify((Object)((Mongo3ChangeEntryRepository)this.repository), (VerificationMode)Mockito.times((int)0))).dropIndex(new Document());
    }

    protected MongoDBDriverTestAdapter getAdapter(String collectionName) {
        return new MongoDb3DriverTestAdapterImpl((MongoCollection<Document>)this.getDataBase().getCollection(collectionName));
    }
}

