/*
 * Decompiled with CFR 0.152.
 */
package monix.eval.internal;

import cats.effect.Async;
import cats.effect.Concurrent;
import cats.effect.ConcurrentEffect;
import cats.effect.Effect;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.LiftIO;
import cats.effect.SyncIO;
import java.io.Serializable;
import monix.eval.Callback;
import monix.eval.Task;
import monix.eval.Task$;
import monix.eval.Task$Async$;
import monix.eval.internal.TaskConversions;
import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.execution.Scheduler;
import monix.execution.UncaughtExceptionReporter;
import monix.execution.cancelables.SingleAssignCancelable;
import monix.execution.cancelables.SingleAssignCancelable$;
import monix.execution.cancelables.StackedCancelable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

public final class TaskConversions$ {
    public static TaskConversions$ MODULE$;

    static {
        new TaskConversions$();
    }

    public <A> IO<A> toIO(Task<A> source, ConcurrentEffect<Task> eff) {
        IO iO;
        Task task = source;
        if (task instanceof Task.Now) {
            Task.Now now = (Task.Now)task;
            Object value = now.value();
            iO = IO$.MODULE$.pure(value);
        } else if (task instanceof Task.Error) {
            Task.Error error = (Task.Error)task;
            Throwable e = error.ex();
            iO = IO$.MODULE$.raiseError(e);
        } else if (task instanceof Task.Eval) {
            Task.Eval eval = (Task.Eval)task;
            Function0 thunk = eval.thunk();
            iO = IO$.MODULE$.apply(thunk);
        } else {
            iO = IO$.MODULE$.cancelable((Function1 & Serializable & scala.Serializable)cb -> MODULE$.toIO((Task)eff.runCancelable((Object)source, (Function1 & Serializable & scala.Serializable)r -> {
                cb.apply(r);
                return IO$.MODULE$.unit();
            }).unsafeRunSync(), eff));
        }
        return iO;
    }

    public <F, A> F toConcurrent(Task<A> source, Concurrent<F> F, ConcurrentEffect<Task> eff) {
        Object object;
        Task task = source;
        if (task instanceof Task.Now) {
            Task.Now now = (Task.Now)task;
            Object value = now.value();
            object = F.pure(value);
        } else if (task instanceof Task.Error) {
            Task.Error error = (Task.Error)task;
            Throwable e = error.ex();
            object = F.raiseError((Object)e);
        } else if (task instanceof Task.Eval) {
            Task.Eval eval = (Task.Eval)task;
            Function0 thunk = eval.thunk();
            object = F.delay(thunk);
        } else {
            object = F.cancelable((Function1 & Serializable & scala.Serializable)cb -> {
                Task token = (Task)eff.runCancelable((Object)source, (Function1 & Serializable & scala.Serializable)r -> {
                    cb.apply(r);
                    return IO$.MODULE$.unit();
                }).unsafeRunSync();
                return MODULE$.toConcurrent(token, F, eff);
            });
        }
        return (F)object;
    }

    public <F, A> F toAsync(Task<A> source, Async<F> F, Effect<Task> eff) {
        Object object;
        Task task = source;
        if (task instanceof Task.Now) {
            Task.Now now = (Task.Now)task;
            Object value = now.value();
            object = F.pure(value);
        } else if (task instanceof Task.Error) {
            Task.Error error = (Task.Error)task;
            Throwable e = error.ex();
            object = F.raiseError((Object)e);
        } else if (task instanceof Task.Eval) {
            Task.Eval eval = (Task.Eval)task;
            Function0 thunk = eval.thunk();
            object = F.delay(thunk);
        } else {
            object = F.async((Function1 & Serializable & scala.Serializable)cb -> {
                TaskConversions$.$anonfun$toAsync$1(eff, task, cb);
                return BoxedUnit.UNIT;
            });
        }
        return (F)object;
    }

    public <F, A> Task<A> fromEffect(F fa, Effect<F> F) {
        Task task;
        F f = fa;
        if (f instanceof Task) {
            Task task2;
            task = task2 = (Task)f;
        } else if (f instanceof IO) {
            IO iO = (IO)f;
            task = (Task)iO.to((LiftIO)Task$.MODULE$.catsAsync());
        } else {
            task = (Task)F.toIO(fa).to((LiftIO)Task$.MODULE$.catsAsync());
        }
        return task;
    }

    public <F, A> Task<A> fromConcurrentEffect(F fa, ConcurrentEffect<F> F) {
        Task task;
        F f = fa;
        if (f instanceof Task) {
            Task task2;
            task = task2 = (Task)f;
        } else if (f instanceof IO) {
            IO iO = (IO)f;
            task = (Task)iO.to((LiftIO)Task$.MODULE$.catsAsync());
        } else {
            task = this.fromConcurrentEffect0(fa, F);
        }
        return task;
    }

    private <F, A> Task<A> fromConcurrentEffect0(F fa, ConcurrentEffect<F> F) {
        Function2 & Serializable & scala.Serializable start = (Function2 & Serializable & scala.Serializable)(ctx, cb) -> {
            TaskConversions$.$anonfun$fromConcurrentEffect0$1(fa, F, ctx, cb);
            return BoxedUnit.UNIT;
        };
        return new Task.Async(start, false, false, Task$Async$.MODULE$.apply$default$4());
    }

    public static final /* synthetic */ void $anonfun$toAsync$1(Effect eff$2, Task x1$1, Function1 cb) {
        eff$2.runAsync((Object)x1$1, (Function1 & Serializable & scala.Serializable)r -> {
            cb.apply(r);
            return IO$.MODULE$.unit();
        }).unsafeRunSync();
    }

    public static final /* synthetic */ void $anonfun$fromConcurrentEffect0$1(Object fa$1, ConcurrentEffect F$2, Task.Context ctx, Callback cb) {
        BoxedUnit boxedUnit;
        try {
            Scheduler sc = ctx.scheduler();
            StackedCancelable conn = ctx.connection();
            SingleAssignCancelable cancelable = SingleAssignCancelable$.MODULE$.apply();
            conn.push((Cancelable)cancelable);
            SyncIO syncIO = F$2.runCancelable(fa$1, new TaskConversions.CreateCallback(conn, cb, sc));
            cancelable.$colon$eq(Cancelable$.MODULE$.fromIO(F$2.toIO(syncIO.unsafeRunSync()), (UncaughtExceptionReporter)sc));
            boxedUnit = BoxedUnit.UNIT;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!NonFatal$.MODULE$.apply(throwable2)) {
                throw throwable;
            }
            ctx.scheduler().reportFailure(throwable2);
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private TaskConversions$() {
        MODULE$ = this;
    }
}

