/*
 * Decompiled with CFR 0.152.
 */
package monix.eval.internal;

import java.io.Serializable;
import monix.eval.Callback;
import monix.eval.Callback$;
import monix.eval.Task;
import monix.eval.Task$Async$;
import monix.eval.Task$Context$;
import monix.eval.internal.StackFrame;
import monix.eval.internal.TaskRestartCallback;
import monix.eval.internal.TaskRestartCallback$;
import monix.eval.internal.TaskRunLoop;
import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.execution.CancelableFuture;
import monix.execution.CancelableFuture$;
import monix.execution.ExecutionModel;
import monix.execution.Scheduler;
import monix.execution.Scheduler$;
import monix.execution.internal.collection.ArrayStack;
import monix.execution.misc.Local$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.collection.immutable.Map;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.control.NonFatal$;

public final class TaskRunLoop$ {
    public static TaskRunLoop$ MODULE$;

    static {
        new TaskRunLoop$();
    }

    public <A> void startFull(Task<A> source, Task.Context contextInit, Callback<A> cb, TaskRestartCallback rcb, Function1<Object, Task<Object>> bFirst, ArrayStack<Function1<Object, Task<Object>>> bRest, int frameIndex) {
        Callback<Object> cba = cb;
        Task current = source;
        Task.Map bFirstRef = bFirst;
        ArrayStack bRestRef = bRest;
        boolean hasUnboxed = false;
        Object unboxed = null;
        int currentIndex = frameIndex;
        Task.Context context = contextInit;
        ExecutionModel em = context.scheduler().executionModel();
        while (currentIndex != 0) {
            BoxedUnit boxedUnit;
            Task<A> task = current;
            if (task instanceof Task.FlatMap) {
                Task.FlatMap flatMap = (Task.FlatMap)task;
                Task fa = flatMap.source();
                Function1 bindNext = flatMap.f();
                if (bFirstRef != null) {
                    if (bRestRef == null) {
                        bRestRef = new ArrayStack();
                    }
                    bRestRef.push(bFirstRef);
                }
                bFirstRef = bindNext;
                current = fa;
                boxedUnit = BoxedUnit.UNIT;
            } else if (task instanceof Task.Now) {
                Task.Now now = (Task.Now)task;
                Object value = now.value();
                unboxed = value;
                hasUnboxed = true;
                boxedUnit = BoxedUnit.UNIT;
            } else if (task instanceof Task.Eval) {
                BoxedUnit boxedUnit2;
                Task.Eval eval = (Task.Eval)task;
                Function0 thunk = eval.thunk();
                try {
                    unboxed = thunk.apply();
                    hasUnboxed = true;
                    current = null;
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (!NonFatal$.MODULE$.apply(throwable2)) {
                        throw throwable;
                    }
                    current = new Task.Error(throwable2);
                    BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit2;
            } else if (task instanceof Task.Map) {
                Task.Map map = (Task.Map)task;
                Task fa = map.source();
                if (bFirstRef != null) {
                    if (bRestRef == null) {
                        bRestRef = new ArrayStack();
                    }
                    bRestRef.push((Object)bFirstRef);
                }
                bFirstRef = map;
                current = fa;
                boxedUnit = BoxedUnit.UNIT;
            } else if (task instanceof Task.Suspend) {
                BoxedUnit boxedUnit4;
                Task.Suspend suspend = (Task.Suspend)task;
                Function0 thunk = suspend.thunk();
                try {
                    current = (Task.Error)thunk.apply();
                    boxedUnit4 = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    Throwable throwable3 = throwable;
                    if (!NonFatal$.MODULE$.apply(throwable3)) {
                        throw throwable;
                    }
                    current = new Task.Error(throwable3);
                    BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
                    boxedUnit4 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit4;
            } else if (task instanceof Task.Error) {
                Task.Error error = (Task.Error)task;
                Throwable error2 = error.ex();
                StackFrame<Object, Task<Object>> stackFrame = this.findErrorHandler(bFirstRef, (ArrayStack<Function1<Object, Task<Object>>>)bRestRef);
                if (stackFrame == null) {
                    cba.onError(error2);
                    return;
                }
                try {
                    current = stackFrame.recover(error2);
                }
                catch (Throwable throwable) {
                    Throwable throwable4 = throwable;
                    if (NonFatal$.MODULE$.apply(throwable4)) {
                        current = new Task.Error(throwable4);
                        BoxedUnit boxedUnit6 = BoxedUnit.UNIT;
                    }
                    throw throwable;
                }
                currentIndex = em.nextFrameIndex(currentIndex);
                bFirstRef = null;
                BoxedUnit boxedUnit7 = BoxedUnit.UNIT;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                if (task instanceof Task.Async) {
                    Task.Async async = (Task.Async)task;
                    this.executeAsyncTask(async, context, cba, rcb, bFirstRef, (ArrayStack<Function1<Object, Task<Object>>>)bRestRef, currentIndex);
                    return;
                }
                if (task instanceof Task.ContextSwitch) {
                    BoxedUnit boxedUnit8;
                    Task.ContextSwitch contextSwitch = (Task.ContextSwitch)task;
                    Task next = contextSwitch.source();
                    Function1<Task.Context, Task.Context> modify = contextSwitch.modify();
                    Function4 restore = contextSwitch.restore();
                    Task.Context old = context;
                    context = (Task.Context)modify.apply((Object)context);
                    current = next;
                    if (context != old) {
                        em = context.scheduler().executionModel();
                        if (rcb != null) {
                            rcb.contextSwitch(context);
                        }
                        if (restore != null) {
                            current = new Task.FlatMap<Object, Object>(next, new TaskRunLoop.RestoreContext(old, restore));
                            boxedUnit8 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit8 = BoxedUnit.UNIT;
                        }
                    } else {
                        boxedUnit8 = BoxedUnit.UNIT;
                    }
                    boxedUnit = boxedUnit8;
                } else {
                    throw new MatchError(task);
                }
            }
            if (!hasUnboxed) continue;
            Function1<Object, Task<Object>> function1 = this.popNextBind(bFirstRef, (ArrayStack<Function1<Object, Task<Object>>>)bRestRef);
            if (function1 == null) {
                cba.onSuccess(unboxed);
                return;
            }
            try {
                current = (Task)function1.apply(unboxed);
            }
            catch (Throwable throwable) {
                Throwable throwable5 = throwable;
                if (NonFatal$.MODULE$.apply(throwable5)) {
                    current = new Task.Error(throwable5);
                    BoxedUnit boxedUnit9 = BoxedUnit.UNIT;
                }
                throw throwable;
            }
            currentIndex = em.nextFrameIndex(currentIndex);
            hasUnboxed = false;
            unboxed = null;
            bFirstRef = null;
            BoxedUnit boxedUnit10 = BoxedUnit.UNIT;
        }
        this.restartAsync(current, context, cba, rcb, bFirstRef, bRestRef);
    }

    public <A> void restartAsync(Task<A> source, Task.Context context, Callback<A> cb, TaskRestartCallback rcb, Function1<Object, Task<Object>> bindCurrent, ArrayStack<Function1<Object, Task<Object>>> bindRest) {
        Map savedLocals = context.options().localContextPropagation() ? Local$.MODULE$.getContext() : null;
        new Scheduler.Extensions(Scheduler$.MODULE$.Extensions(context.scheduler())).executeAsync(() -> {
            if (!context.shouldCancel()) {
                context.frameRef().reset();
                Map ctx$macro$1 = savedLocals;
                if (ctx$macro$1 == null) {
                    MODULE$.startFull(source, context, cb, rcb, bindCurrent, bindRest, 1);
                } else {
                    Map saved$macro$2 = Local$.MODULE$.getContext();
                    Local$.MODULE$.setContext(ctx$macro$1);
                    try {
                        MODULE$.startFull(source, context, cb, rcb, bindCurrent, bindRest, 1);
                    }
                    finally {
                        Local$.MODULE$.setContext(saved$macro$2);
                    }
                }
            }
        });
    }

    public <A> Cancelable startLight(Task<A> source, Scheduler scheduler, Task.Options opts, Callback<A> cb) {
        Task current = source;
        Task.Map bFirst = null;
        ArrayStack bRest = null;
        boolean hasUnboxed = false;
        Object unboxed = null;
        ExecutionModel em = scheduler.executionModel();
        int frameIndex = this.frameStart(em);
        while (frameIndex != 0) {
            BoxedUnit boxedUnit;
            Task<Object> task = current;
            if (task instanceof Task.FlatMap) {
                Task.FlatMap flatMap = (Task.FlatMap)task;
                Task fa = flatMap.source();
                Task.Map bindNext = flatMap.f();
                if (bFirst != null) {
                    if (bRest == null) {
                        bRest = new ArrayStack();
                    }
                    bRest.push(bFirst);
                }
                bFirst = bindNext;
                current = fa;
                boxedUnit = BoxedUnit.UNIT;
            } else if (task instanceof Task.Now) {
                Task.Now now = (Task.Now)task;
                Object value = now.value();
                unboxed = value;
                hasUnboxed = true;
                boxedUnit = BoxedUnit.UNIT;
            } else if (task instanceof Task.Eval) {
                BoxedUnit boxedUnit2;
                Task.Eval eval = (Task.Eval)task;
                Function0 thunk = eval.thunk();
                try {
                    unboxed = thunk.apply();
                    hasUnboxed = true;
                    current = null;
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (!NonFatal$.MODULE$.apply(throwable2)) {
                        throw throwable;
                    }
                    current = new Task.Error(throwable2);
                    BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit2;
            } else if (task instanceof Task.Map) {
                Task.Map map = (Task.Map)task;
                Task fa = map.source();
                if (bFirst != null) {
                    if (bRest == null) {
                        bRest = new ArrayStack();
                    }
                    bRest.push((Object)bFirst);
                }
                bFirst = map;
                current = fa;
                boxedUnit = BoxedUnit.UNIT;
            } else if (task instanceof Task.Suspend) {
                BoxedUnit boxedUnit4;
                Task.Suspend suspend = (Task.Suspend)task;
                Function0 thunk = suspend.thunk();
                try {
                    current = (Task.Error)thunk.apply();
                    boxedUnit4 = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    Throwable throwable3 = throwable;
                    if (!NonFatal$.MODULE$.apply(throwable3)) {
                        throw throwable;
                    }
                    current = new Task.Error(throwable3);
                    BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
                    boxedUnit4 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit4;
            } else if (task instanceof Task.Error) {
                Task.Error error = (Task.Error)task;
                Throwable error2 = error.ex();
                StackFrame<Object, Task<Object>> stackFrame = this.findErrorHandler(bFirst, (ArrayStack<Function1<Object, Task<Object>>>)bRest);
                if (stackFrame == null) {
                    cb.onError(error2);
                    return Cancelable$.MODULE$.empty();
                }
                try {
                    current = stackFrame.recover(error2);
                }
                catch (Throwable throwable) {
                    Throwable throwable4 = throwable;
                    if (NonFatal$.MODULE$.apply(throwable4)) {
                        current = new Task.Error(throwable4);
                        BoxedUnit boxedUnit6 = BoxedUnit.UNIT;
                    }
                    throw throwable;
                }
                frameIndex = em.nextFrameIndex(frameIndex);
                bFirst = null;
                BoxedUnit boxedUnit7 = BoxedUnit.UNIT;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                return this.goAsyncForLightCB(task, scheduler, opts, cb, bFirst, (ArrayStack<Function1<Object, Task<Object>>>)bRest, frameIndex, false);
            }
            if (!hasUnboxed) continue;
            Function1<Object, Task<Object>> function1 = this.popNextBind(bFirst, (ArrayStack<Function1<Object, Task<Object>>>)bRest);
            if (function1 == null) {
                cb.onSuccess(unboxed);
                return Cancelable$.MODULE$.empty();
            }
            try {
                current = (Task)function1.apply(unboxed);
            }
            catch (Throwable throwable) {
                Throwable throwable5 = throwable;
                if (NonFatal$.MODULE$.apply(throwable5)) {
                    current = new Task.Error(throwable5);
                    BoxedUnit boxedUnit8 = BoxedUnit.UNIT;
                }
                throw throwable;
            }
            frameIndex = em.nextFrameIndex(frameIndex);
            hasUnboxed = false;
            unboxed = null;
            bFirst = null;
            BoxedUnit boxedUnit9 = BoxedUnit.UNIT;
        }
        return this.goAsyncForLightCB(current, scheduler, opts, cb, bFirst, bRest, frameIndex, true);
    }

    public <A> Either<Task<A>, A> startStep(Task<A> source, Scheduler scheduler, Task.Options opts) {
        Task current = source;
        Task.Map bFirst = null;
        ArrayStack bRest = null;
        boolean hasUnboxed = false;
        Object unboxed = null;
        ExecutionModel em = scheduler.executionModel();
        int frameIndex = this.frameStart(em);
        while (frameIndex != 0) {
            BoxedUnit boxedUnit;
            Task<Object> task = current;
            if (task instanceof Task.FlatMap) {
                Task.FlatMap flatMap = (Task.FlatMap)task;
                Task fa = flatMap.source();
                Task.Map bindNext = flatMap.f();
                if (bFirst != null) {
                    if (bRest == null) {
                        bRest = new ArrayStack();
                    }
                    bRest.push(bFirst);
                }
                bFirst = bindNext;
                current = fa;
                boxedUnit = BoxedUnit.UNIT;
            } else if (task instanceof Task.Now) {
                Task.Now now = (Task.Now)task;
                Object value = now.value();
                unboxed = value;
                hasUnboxed = true;
                boxedUnit = BoxedUnit.UNIT;
            } else if (task instanceof Task.Eval) {
                BoxedUnit boxedUnit2;
                Task.Eval eval = (Task.Eval)task;
                Function0 thunk = eval.thunk();
                try {
                    unboxed = thunk.apply();
                    hasUnboxed = true;
                    current = null;
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (!NonFatal$.MODULE$.apply(throwable2)) {
                        throw throwable;
                    }
                    current = new Task.Error(throwable2);
                    BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit2;
            } else if (task instanceof Task.Map) {
                Task.Map map = (Task.Map)task;
                Task fa = map.source();
                if (bFirst != null) {
                    if (bRest == null) {
                        bRest = new ArrayStack();
                    }
                    bRest.push((Object)bFirst);
                }
                bFirst = map;
                current = fa;
                boxedUnit = BoxedUnit.UNIT;
            } else if (task instanceof Task.Suspend) {
                BoxedUnit boxedUnit4;
                Task.Suspend suspend = (Task.Suspend)task;
                Function0 thunk = suspend.thunk();
                try {
                    current = (Task.Error)thunk.apply();
                    boxedUnit4 = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    Throwable throwable3 = throwable;
                    if (!NonFatal$.MODULE$.apply(throwable3)) {
                        throw throwable;
                    }
                    current = new Task.Error(throwable3);
                    BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
                    boxedUnit4 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit4;
            } else if (task instanceof Task.Error) {
                Task.Error error = (Task.Error)task;
                Throwable error2 = error.ex();
                StackFrame<Object, Task<Object>> stackFrame = this.findErrorHandler(bFirst, (ArrayStack<Function1<Object, Task<Object>>>)bRest);
                if (stackFrame == null) {
                    throw error2;
                }
                try {
                    current = stackFrame.recover(error2);
                }
                catch (Throwable throwable) {
                    Throwable throwable4 = throwable;
                    if (NonFatal$.MODULE$.apply(throwable4)) {
                        current = new Task.Error(throwable4);
                        BoxedUnit boxedUnit6 = BoxedUnit.UNIT;
                    }
                    throw throwable;
                }
                frameIndex = em.nextFrameIndex(frameIndex);
                bFirst = null;
                BoxedUnit boxedUnit7 = BoxedUnit.UNIT;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                return this.goAsync4Step(task, scheduler, opts, bFirst, (ArrayStack<Function1<Object, Task<Object>>>)bRest, frameIndex, false);
            }
            if (!hasUnboxed) continue;
            Function1<Object, Task<Object>> function1 = this.popNextBind(bFirst, (ArrayStack<Function1<Object, Task<Object>>>)bRest);
            if (function1 == null) {
                return package$.MODULE$.Right().apply(unboxed);
            }
            try {
                current = (Task)function1.apply(unboxed);
            }
            catch (Throwable throwable) {
                Throwable throwable5 = throwable;
                if (NonFatal$.MODULE$.apply(throwable5)) {
                    current = new Task.Error(throwable5);
                    BoxedUnit boxedUnit8 = BoxedUnit.UNIT;
                }
                throw throwable;
            }
            frameIndex = em.nextFrameIndex(frameIndex);
            hasUnboxed = false;
            unboxed = null;
            bFirst = null;
            BoxedUnit boxedUnit9 = BoxedUnit.UNIT;
        }
        return this.goAsync4Step(current, scheduler, opts, bFirst, bRest, frameIndex, true);
    }

    public <A> CancelableFuture<A> startFuture(Task<A> source, Scheduler scheduler, Task.Options opts) {
        Task current = source;
        Task.Map bFirst = null;
        ArrayStack bRest = null;
        boolean hasUnboxed = false;
        Object unboxed = null;
        ExecutionModel em = scheduler.executionModel();
        int frameIndex = this.frameStart(em);
        while (frameIndex != 0) {
            BoxedUnit boxedUnit;
            Task<Object> task = current;
            if (task instanceof Task.FlatMap) {
                Task.FlatMap flatMap = (Task.FlatMap)task;
                Task fa = flatMap.source();
                Task.Map bindNext = flatMap.f();
                if (bFirst != null) {
                    if (bRest == null) {
                        bRest = new ArrayStack();
                    }
                    bRest.push(bFirst);
                }
                bFirst = bindNext;
                current = fa;
                boxedUnit = BoxedUnit.UNIT;
            } else if (task instanceof Task.Now) {
                Task.Now now = (Task.Now)task;
                Object value = now.value();
                unboxed = value;
                hasUnboxed = true;
                boxedUnit = BoxedUnit.UNIT;
            } else if (task instanceof Task.Eval) {
                BoxedUnit boxedUnit2;
                Task.Eval eval = (Task.Eval)task;
                Function0 thunk = eval.thunk();
                try {
                    unboxed = thunk.apply();
                    hasUnboxed = true;
                    current = null;
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (!NonFatal$.MODULE$.apply(throwable2)) {
                        throw throwable;
                    }
                    current = new Task.Error(throwable2);
                    BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit2;
            } else if (task instanceof Task.Map) {
                Task.Map map = (Task.Map)task;
                Task fa = map.source();
                if (bFirst != null) {
                    if (bRest == null) {
                        bRest = new ArrayStack();
                    }
                    bRest.push((Object)bFirst);
                }
                bFirst = map;
                current = fa;
                boxedUnit = BoxedUnit.UNIT;
            } else if (task instanceof Task.Suspend) {
                BoxedUnit boxedUnit4;
                Task.Suspend suspend = (Task.Suspend)task;
                Function0 thunk = suspend.thunk();
                try {
                    current = (Task.Error)thunk.apply();
                    boxedUnit4 = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    Throwable throwable3 = throwable;
                    if (!NonFatal$.MODULE$.apply(throwable3)) {
                        throw throwable;
                    }
                    current = new Task.Error(throwable3);
                    BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
                    boxedUnit4 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit4;
            } else if (task instanceof Task.Error) {
                Task.Error error = (Task.Error)task;
                Throwable error2 = error.ex();
                StackFrame<Object, Task<Object>> stackFrame = this.findErrorHandler(bFirst, (ArrayStack<Function1<Object, Task<Object>>>)bRest);
                if (stackFrame == null) {
                    return CancelableFuture$.MODULE$.failed(error2);
                }
                try {
                    current = stackFrame.recover(error2);
                }
                catch (Throwable throwable) {
                    Throwable throwable4 = throwable;
                    if (NonFatal$.MODULE$.apply(throwable4)) {
                        current = new Task.Error(throwable4);
                        BoxedUnit boxedUnit6 = BoxedUnit.UNIT;
                    }
                    throw throwable;
                }
                frameIndex = em.nextFrameIndex(frameIndex);
                bFirst = null;
                BoxedUnit boxedUnit7 = BoxedUnit.UNIT;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                return this.goAsync4Future(task, scheduler, opts, bFirst, (ArrayStack<Function1<Object, Task<Object>>>)bRest, frameIndex, false);
            }
            if (!hasUnboxed) continue;
            Function1<Object, Task<Object>> function1 = this.popNextBind(bFirst, (ArrayStack<Function1<Object, Task<Object>>>)bRest);
            if (function1 == null) {
                return CancelableFuture$.MODULE$.successful(unboxed);
            }
            try {
                current = (Task)function1.apply(unboxed);
            }
            catch (Throwable throwable) {
                Throwable throwable5 = throwable;
                if (NonFatal$.MODULE$.apply(throwable5)) {
                    current = new Task.Error(throwable5);
                    BoxedUnit boxedUnit8 = BoxedUnit.UNIT;
                }
                throw throwable;
            }
            frameIndex = em.nextFrameIndex(frameIndex);
            hasUnboxed = false;
            unboxed = null;
            bFirst = null;
            BoxedUnit boxedUnit9 = BoxedUnit.UNIT;
        }
        return this.goAsync4Future(current, scheduler, opts, bFirst, bRest, frameIndex, true);
    }

    public void executeAsyncTask(Task.Async<Object> task, Task.Context context, Callback<Object> cb, TaskRestartCallback rcb, Function1<Object, Task<Object>> bFirst, ArrayStack<Function1<Object, Task<Object>>> bRest, int nextFrame) {
        context.frameRef().$colon$eq(nextFrame);
        TaskRestartCallback restartCallback = rcb != null ? rcb : TaskRestartCallback$.MODULE$.apply(context, cb);
        restartCallback.start(task, bFirst, bRest);
    }

    private Cancelable goAsyncForLightCB(Task<Object> source, Scheduler scheduler, Task.Options opts, Callback<Object> cb, Function1<Object, Task<Object>> bFirst, ArrayStack<Function1<Object, Task<Object>>> bRest, int nextFrame, boolean forceFork) {
        Task.Context context = Task$Context$.MODULE$.apply(scheduler, opts);
        if (!forceFork) {
            Task<Object> task = source;
            if (task instanceof Task.Async) {
                Task.Async async = (Task.Async)task;
                this.executeAsyncTask(async, context, cb, null, bFirst, bRest, 1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                this.startFull(source, context, cb, null, bFirst, bRest, nextFrame);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            this.restartAsync(source, context, cb, null, bFirst, bRest);
        }
        return context.connection();
    }

    private <A> CancelableFuture<A> goAsync4Future(Task<Object> source, Scheduler scheduler, Task.Options opts, Function1<Object, Task<Object>> bFirst, ArrayStack<Function1<Object, Task<Object>>> bRest, int nextFrame, boolean forceFork) {
        Promise p = Promise$.MODULE$.apply();
        Callback<Object> cb = Callback$.MODULE$.fromPromise(p);
        Task.Context context = Task$Context$.MODULE$.apply(scheduler, opts);
        Task<Object> current = source;
        if (!forceFork) {
            Task<Object> task = source;
            if (task instanceof Task.Async) {
                Task.Async async = (Task.Async)task;
                this.executeAsyncTask(async, context, cb, null, bFirst, bRest, 1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                this.startFull(source, context, cb, null, bFirst, bRest, nextFrame);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            this.restartAsync(current, context, cb, null, bFirst, bRest);
        }
        return CancelableFuture$.MODULE$.apply(p.future(), (Cancelable)context.connection());
    }

    private <A> Either<Task<A>, A> goAsync4Step(Task<Object> source, Scheduler scheduler, Task.Options opts, Function1<Object, Task<Object>> bFirst, ArrayStack<Function1<Object, Task<Object>>> bRest, int nextFrame, boolean forceFork) {
        Function2 & Serializable & scala.Serializable intersect;
        Task.Context ctx2 = Task$Context$.MODULE$.apply(scheduler, opts);
        if (!forceFork) {
            ctx2.frameRef().$colon$eq(nextFrame);
            intersect = (Function2 & Serializable & scala.Serializable)(ctx, cb) -> {
                TaskRunLoop$.MODULE$.startFull(source, ctx, cb, null, (Function1<Object, Task<Object>>)bFirst, (ArrayStack<Function1<Object, Task<Object>>>)bRest, ctx.frameRef().apply());
                return BoxedUnit.UNIT;
            };
        } else {
            intersect = (Function2 & Serializable & scala.Serializable)(ctx, cb) -> {
                TaskRunLoop$.$anonfun$goAsync4Step$2(source, bFirst, bRest, ctx, cb);
                return BoxedUnit.UNIT;
            };
        }
        Function2 & Serializable & scala.Serializable start = intersect;
        return package$.MODULE$.Left().apply(new Task.Async(start, false, false, Task$Async$.MODULE$.apply$default$4()));
    }

    public StackFrame<Object, Task<Object>> findErrorHandler(Function1<Object, Task<Object>> bFirst, ArrayStack<Function1<Object, Task<Object>>> bRest) {
        StackFrame stackFrame;
        Function1<Object, Task<Object>> function1 = bFirst;
        if (function1 instanceof StackFrame) {
            StackFrame stackFrame2;
            stackFrame = stackFrame2 = (StackFrame)function1;
        } else {
            if (bRest != null) {
                Function1 ref;
                do {
                    if ((ref = (Function1)bRest.pop()) != null) continue;
                    return null;
                } while (!(ref instanceof StackFrame));
                return (StackFrame)ref;
            }
            stackFrame = null;
        }
        return stackFrame;
    }

    public Function1<Object, Task<Object>> popNextBind(Function1<Object, Task<Object>> bFirst, ArrayStack<Function1<Object, Task<Object>>> bRest) {
        Function1 next;
        if (bFirst != null && !(bFirst instanceof StackFrame.ErrorHandler)) {
            return bFirst;
        }
        if (bRest == null) {
            return null;
        }
        do {
            if ((next = (Function1)bRest.pop()) != null) continue;
            return null;
        } while (next instanceof StackFrame.ErrorHandler);
        return next;
    }

    private int frameStart(ExecutionModel em) {
        return em.nextFrameIndex(0);
    }

    public static final /* synthetic */ void $anonfun$goAsync4Step$2(Task source$2, Function1 bFirst$1, ArrayStack bRest$1, Task.Context ctx, Callback cb) {
        new Scheduler.Extensions(Scheduler$.MODULE$.Extensions(ctx.scheduler())).executeAsync(() -> MODULE$.startFull(source$2, ctx, cb, null, (Function1<Object, Task<Object>>)bFirst$1, (ArrayStack<Function1<Object, Task<Object>>>)bRest$1, 1));
    }

    private TaskRunLoop$() {
        MODULE$ = this;
    }
}

