/*
 * Decompiled with CFR 0.152.
 */
package monix.eval.internal;

import cats.effect.Async;
import cats.effect.Concurrent;
import cats.effect.ConcurrentEffect;
import cats.effect.Effect;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.LiftIO;
import cats.effect.SyncIO;
import monix.eval.Task;
import monix.eval.Task$;
import monix.eval.Task$Async$;
import monix.eval.internal.TaskConnection;
import monix.eval.internal.TaskConnectionRef;
import monix.eval.internal.TaskConnectionRef$;
import monix.eval.internal.TaskConversions;
import monix.execution.Callback;
import monix.execution.Scheduler;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Serializable;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.control.NonFatal$;

public final class TaskConversions$ {
    public static final TaskConversions$ MODULE$;

    static {
        new TaskConversions$();
    }

    public <A> IO<A> toIO(Task<A> source, ConcurrentEffect<Task> eff) {
        IO iO;
        Task<A> task = source;
        if (task instanceof Task.Now) {
            Task.Now now = (Task.Now)task;
            Object value = now.value();
            iO = IO$.MODULE$.pure(value);
        } else if (task instanceof Task.Error) {
            Task.Error error = (Task.Error)task;
            Throwable e = error.e();
            iO = IO$.MODULE$.raiseError(e);
        } else if (task instanceof Task.Eval) {
            Task.Eval eval = (Task.Eval)task;
            Function0 thunk = eval.thunk();
            iO = IO$.MODULE$.apply(thunk);
        } else {
            iO = IO$.MODULE$.cancelable((Function1)new Serializable(source, eff){
                public static final long serialVersionUID = 0L;
                private final Task source$2;
                private final ConcurrentEffect eff$3;

                public final IO<BoxedUnit> apply(Function1<Either<Throwable, A>, BoxedUnit> cb) {
                    return TaskConversions$.MODULE$.toIO((Task)this.eff$3.runCancelable((Object)this.source$2, (Function1)new Serializable(this, cb){
                        public static final long serialVersionUID = 0L;
                        private final Function1 cb$1;

                        public final IO<BoxedUnit> apply(Either<Throwable, A> r) {
                            this.cb$1.apply(r);
                            return IO$.MODULE$.unit();
                        }
                        {
                            this.cb$1 = cb$1;
                        }
                    }).unsafeRunSync(), (ConcurrentEffect<Task>)this.eff$3);
                }
                {
                    this.source$2 = source$2;
                    this.eff$3 = eff$3;
                }
            });
        }
        return iO;
    }

    public <F, A> F toConcurrent(Task<A> source, Concurrent<F> F, ConcurrentEffect<Task> eff) {
        Object object;
        Task<A> task = source;
        if (task instanceof Task.Now) {
            Task.Now now = (Task.Now)task;
            Object value = now.value();
            object = F.pure(value);
        } else if (task instanceof Task.Error) {
            Task.Error error = (Task.Error)task;
            Throwable e = error.e();
            object = F.raiseError((Object)e);
        } else if (task instanceof Task.Eval) {
            Task.Eval eval = (Task.Eval)task;
            Function0 thunk = eval.thunk();
            object = F.delay(thunk);
        } else {
            object = F.cancelable((Function1)new Serializable(source, F, eff){
                public static final long serialVersionUID = 0L;
                private final Task source$1;
                private final Concurrent F$1;
                private final ConcurrentEffect eff$1;

                public final F apply(Function1<Either<Throwable, A>, BoxedUnit> cb) {
                    Task token = (Task)this.eff$1.runCancelable((Object)this.source$1, (Function1)new Serializable(this, cb){
                        public static final long serialVersionUID = 0L;
                        private final Function1 cb$2;

                        public final IO<BoxedUnit> apply(Either<Throwable, A> r) {
                            this.cb$2.apply(r);
                            return IO$.MODULE$.unit();
                        }
                        {
                            this.cb$2 = cb$2;
                        }
                    }).unsafeRunSync();
                    return TaskConversions$.MODULE$.toConcurrent(token, this.F$1, (ConcurrentEffect<Task>)this.eff$1);
                }
                {
                    this.source$1 = source$1;
                    this.F$1 = F$1;
                    this.eff$1 = eff$1;
                }
            });
        }
        return (F)object;
    }

    public <F, A> F toAsync(Task<A> source, Async<F> F, Effect<Task> eff) {
        Object object;
        Task<A> task = source;
        if (task instanceof Task.Now) {
            Task.Now now = (Task.Now)task;
            Object value = now.value();
            object = F.pure(value);
        } else if (task instanceof Task.Error) {
            Task.Error error = (Task.Error)task;
            Throwable e = error.e();
            object = F.raiseError((Object)e);
        } else if (task instanceof Task.Eval) {
            Task.Eval eval = (Task.Eval)task;
            Function0 thunk = eval.thunk();
            object = F.delay(thunk);
        } else {
            object = F.async((Function1)new Serializable(eff, task){
                public static final long serialVersionUID = 0L;
                private final Effect eff$2;
                private final Task x1$1;

                public final void apply(Function1<Either<Throwable, A>, BoxedUnit> cb) {
                    this.eff$2.runAsync((Object)this.x1$1, (Function1)new Serializable(this, cb){
                        public static final long serialVersionUID = 0L;
                        private final Function1 cb$3;

                        public final IO<BoxedUnit> apply(Either<Throwable, A> r) {
                            this.cb$3.apply(r);
                            return IO$.MODULE$.unit();
                        }
                        {
                            this.cb$3 = cb$3;
                        }
                    }).unsafeRunSync();
                }
                {
                    this.eff$2 = eff$2;
                    this.x1$1 = x1$1;
                }
            });
        }
        return (F)object;
    }

    public <F, A> Task<A> fromEffect(F fa, Effect<F> F) {
        Task task;
        F f = fa;
        if (f instanceof Task) {
            Task task2;
            task = task2 = (Task)f;
        } else if (f instanceof IO) {
            IO iO = (IO)f;
            task = (Task)iO.to((LiftIO)Task$.MODULE$.catsAsync());
        } else {
            task = this.fromEffect0(fa, F);
        }
        return task;
    }

    private <F, A> Task<A> fromEffect0(F fa, Effect<F> F) {
        Serializable start = new Serializable(fa, F){
            public static final long serialVersionUID = 0L;
            private final Object fa$1;
            private final Effect F$2;

            public final void apply(Task.Context ctx, Callback<Throwable, A> cb) {
                try {
                    Scheduler sc = ctx.scheduler();
                    SyncIO io = this.F$2.runAsync(this.fa$1, new TaskConversions.CreateCallback<A>(null, cb, sc));
                    io.unsafeRunSync();
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    ctx.scheduler().reportFailure(e);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            {
                this.fa$1 = fa$1;
                this.F$2 = F$2;
            }
        };
        return new Task.Async(start, false, false, Task$Async$.MODULE$.apply$default$4());
    }

    public <F, A> Task<A> fromConcurrentEffect(F fa, ConcurrentEffect<F> F) {
        Task task;
        F f = fa;
        if (f instanceof Task) {
            Task task2;
            task = task2 = (Task)f;
        } else if (f instanceof IO) {
            IO iO = (IO)f;
            task = (Task)iO.to((LiftIO)Task$.MODULE$.catsAsync());
        } else {
            task = this.fromConcurrentEffect0(fa, F);
        }
        return task;
    }

    private <F, A> Task<A> fromConcurrentEffect0(F fa, ConcurrentEffect<F> F) {
        Serializable start = new Serializable(fa, F){
            public static final long serialVersionUID = 0L;
            private final Object fa$2;
            private final ConcurrentEffect F$3;

            public final void apply(Task.Context ctx, Callback<Throwable, A> cb) {
                Throwable throwable2;
                block2: {
                    try {
                        Scheduler sc = ctx.scheduler();
                        TaskConnection conn = ctx.connection();
                        TaskConnectionRef cancelable2 = TaskConnectionRef$.MODULE$.apply();
                        conn.push((Task<BoxedUnit>)cancelable2.cancel(), sc);
                        SyncIO syncIO = this.F$3.runCancelable(this.fa$2, new TaskConversions.CreateCallback<A>(conn, cb, sc));
                        cancelable2.$colon$eq(TaskConversions$.MODULE$.fromEffect(syncIO.unsafeRunSync(), this.F$3), sc);
                    }
                    catch (Throwable throwable2) {
                        Throwable throwable3 = throwable2;
                        if (!NonFatal$.MODULE$.apply(throwable3)) break block2;
                        ctx.scheduler().reportFailure(throwable3);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    return;
                }
                throw throwable2;
            }
            {
                this.fa$2 = fa$2;
                this.F$3 = F$3;
            }
        };
        return new Task.Async(start, false, false, Task$Async$.MODULE$.apply$default$4());
    }

    private TaskConversions$() {
        MODULE$ = this;
    }
}

