/*
 * Decompiled with CFR 0.152.
 */
package monix.execution;

import java.util.concurrent.TimeoutException;
import monix.execution.Cancelable;
import monix.execution.Scheduler;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Serializable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.FiniteDuration;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class FutureUtils$ {
    public static final FutureUtils$ MODULE$;

    static {
        new FutureUtils$();
    }

    public <T> Future<T> timeout(Future<T> source, FiniteDuration atMost, Scheduler s) {
        TimeoutException err = new TimeoutException();
        Promise promise = Promise$.MODULE$.apply();
        Cancelable task = s.scheduleOnce(atMost.length(), atMost.unit(), new Runnable(err, promise){
            private final TimeoutException err$1;
            private final Promise promise$1;

            public void run() {
                this.promise$1.tryFailure((Throwable)this.err$1);
            }
            {
                this.err$1 = err$1;
                this.promise$1 = promise$1;
            }
        });
        source.onComplete((Function1)new Serializable(promise, task){
            public static final long serialVersionUID = 0L;
            private final Promise promise$1;
            private final Cancelable task$1;

            public final boolean apply(Try<T> x0$1) {
                this.task$1.cancel();
                return this.promise$1.tryComplete(x0$1);
            }
            {
                this.promise$1 = promise$1;
                this.task$1 = task$1;
            }
        }, (ExecutionContext)s);
        return promise.future();
    }

    public <T> Future<T> timeoutTo(Future<T> source, FiniteDuration atMost, Function0<Future<T>> fallback, Scheduler s) {
        Promise promise = Promise$.MODULE$.apply();
        Cancelable task = s.scheduleOnce(atMost.length(), atMost.unit(), new Runnable(fallback, promise){
            private final Function0 fallback$1;
            private final Promise promise$2;

            public void run() {
                this.promise$2.tryCompleteWith((Future)this.fallback$1.apply());
            }
            {
                this.fallback$1 = fallback$1;
                this.promise$2 = promise$2;
            }
        });
        source.onComplete((Function1)new Serializable(promise, task){
            public static final long serialVersionUID = 0L;
            private final Promise promise$2;
            private final Cancelable task$2;

            public final boolean apply(Try<T> x0$2) {
                this.task$2.cancel();
                return this.promise$2.tryComplete(x0$2);
            }
            {
                this.promise$2 = promise$2;
                this.task$2 = task$2;
            }
        }, (ExecutionContext)s);
        return promise.future();
    }

    public <T> Future<Try<T>> materialize(Future<T> source, ExecutionContext ec) {
        Future future;
        if (source.isCompleted()) {
            future = Future$.MODULE$.successful(source.value().get());
        } else {
            Promise p = Promise$.MODULE$.apply();
            source.onComplete((Function1)new Serializable(p){
                public static final long serialVersionUID = 0L;
                private final Promise p$1;

                public final Promise<Try<T>> apply(Try<T> x0$3) {
                    return this.p$1.success(x0$3);
                }
                {
                    this.p$1 = p$1;
                }
            }, ec);
            future = p.future();
        }
        return future;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> Future<T> dematerialize(Future<Try<T>> source, ExecutionContext ec) {
        Future future;
        if (source.isCompleted()) {
            Future future2;
            Try try_ = (Try)source.value().get();
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                future2 = Future$.MODULE$.failed(failure.exception());
            } else {
                Future future3;
                if (!(try_ instanceof Success)) throw new MatchError((Object)try_);
                Success success = (Success)try_;
                Try try_2 = (Try)success.value();
                if (try_2 instanceof Success) {
                    Success success2 = (Success)try_2;
                    future3 = Future$.MODULE$.successful(success2.value());
                } else {
                    if (!(try_2 instanceof Failure)) throw new MatchError((Object)try_2);
                    Failure failure = (Failure)try_2;
                    future3 = Future$.MODULE$.failed(failure.exception());
                }
                future2 = future3;
            }
            future = future2;
            return future;
        } else {
            Promise p = Promise$.MODULE$.apply();
            source.onComplete((Function1)new Serializable(p){
                public static final long serialVersionUID = 0L;
                private final Promise p$2;

                public final Promise<T> apply(Try<Try<T>> x0$4) {
                    block4: {
                        Promise promise;
                        block3: {
                            block2: {
                                if (!(x0$4 instanceof Failure)) break block2;
                                Failure failure = (Failure)x0$4;
                                promise = this.p$2.failure(failure.exception());
                                break block3;
                            }
                            if (!(x0$4 instanceof Success)) break block4;
                            Success success = (Success)x0$4;
                            promise = this.p$2.complete((Try)success.value());
                        }
                        return promise;
                    }
                    throw new MatchError(x0$4);
                }
                {
                    this.p$2 = p$2;
                }
            }, ec);
            future = p.future();
        }
        return future;
    }

    public <T> Future<T> delayedResult(FiniteDuration delay, Function0<T> result, Scheduler s) {
        Promise p = Promise$.MODULE$.apply();
        s.scheduleOnce(delay.length(), delay.unit(), new Runnable(result, p){
            private final Function0 result$1;
            private final Promise p$3;

            public void run() {
                this.p$3.complete(Try$.MODULE$.apply(this.result$1));
            }
            {
                this.result$1 = result$1;
                this.p$3 = p$3;
            }
        });
        return p.future();
    }

    private FutureUtils$() {
        MODULE$ = this;
    }
}

