/*
 * Decompiled with CFR 0.152.
 */
package monix.execution.internals.atomic;

import java.lang.reflect.Field;
import monix.execution.internals.atomic.BoxedInt;
import monix.execution.internals.atomic.UnsafeAccess;
import sun.misc.Unsafe;

abstract class Right64Java8BoxedIntImpl
implements BoxedInt {
    public volatile int value;
    private static final long OFFSET;
    private static final Unsafe UNSAFE;

    Right64Java8BoxedIntImpl(int n) {
        this.value = n;
    }

    @Override
    public int volatileGet() {
        return this.value;
    }

    @Override
    public void volatileSet(int n) {
        this.value = n;
    }

    @Override
    public void lazySet(int n) {
        UNSAFE.putOrderedInt(this, OFFSET, n);
    }

    @Override
    public boolean compareAndSet(int n, int n2) {
        return UNSAFE.compareAndSwapInt(this, OFFSET, n, n2);
    }

    @Override
    public int getAndSet(int n) {
        return UNSAFE.getAndSetInt(this, OFFSET, n);
    }

    @Override
    public int getAndAdd(int n) {
        return UNSAFE.getAndAddInt(this, OFFSET, n);
    }

    static {
        UNSAFE = (Unsafe)UnsafeAccess.getInstance();
        try {
            Field field = Right64Java8BoxedIntImpl.class.getDeclaredField("value");
            OFFSET = UNSAFE.objectFieldOffset(field);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

