/*
 * Decompiled with CFR 0.152.
 */
package monix.execution;

import java.util.concurrent.TimeoutException;
import monix.execution.Cancelable;
import monix.execution.CancelableFuture;
import monix.execution.Scheduler;
import monix.execution.schedulers.TrampolineExecutionContext$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.MonixInternals$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.FiniteDuration;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public final class FutureUtils$ {
    public static final FutureUtils$ MODULE$;

    static {
        new FutureUtils$();
    }

    public <A> Future<A> timeout(Future<A> source, FiniteDuration atMost, Scheduler s) {
        TimeoutException err = new TimeoutException();
        Promise promise = Promise$.MODULE$.apply();
        Cancelable task = s.scheduleOnce(atMost.length(), atMost.unit(), new Runnable(err, promise){
            private final TimeoutException err$1;
            private final Promise promise$1;

            public void run() {
                this.promise$1.tryFailure((Throwable)this.err$1);
            }
            {
                this.err$1 = err$1;
                this.promise$1 = promise$1;
            }
        });
        source.onComplete((Function1)new Serializable(promise, task){
            public static final long serialVersionUID = 0L;
            private final Promise promise$1;
            private final Cancelable task$1;

            public final boolean apply(Try<A> r) {
                this.task$1.cancel();
                return this.promise$1.tryComplete(r);
            }
            {
                this.promise$1 = promise$1;
                this.task$1 = task$1;
            }
        }, (ExecutionContext)s);
        return promise.future();
    }

    public <A> Future<A> timeoutTo(Future<A> source, FiniteDuration atMost, Function0<Future<A>> fallback, Scheduler s) {
        Promise promise = Promise$.MODULE$.apply();
        Cancelable task = s.scheduleOnce(atMost.length(), atMost.unit(), new Runnable(promise){
            private final Promise promise$2;

            public void run() {
                this.promise$2.trySuccess((Object)None$.MODULE$);
            }
            {
                this.promise$2 = promise$2;
            }
        });
        source.onComplete((Function1)new Serializable(promise, task){
            public static final long serialVersionUID = 0L;
            private final Promise promise$2;
            private final Cancelable task$2;

            public final boolean apply(Try<A> r) {
                this.task$2.cancel();
                return this.promise$2.trySuccess((Object)new Some(r));
            }
            {
                this.promise$2 = promise$2;
                this.task$2 = task$2;
            }
        }, (ExecutionContext)s);
        return promise.future().flatMap((Function1)new Serializable(fallback){
            public static final long serialVersionUID = 0L;
            private final Function0 fallback$1;

            public final Future<A> apply(Option<Try<A>> x0$1) {
                Option<Try<A>> option;
                block4: {
                    Future future;
                    block3: {
                        block2: {
                            option = x0$1;
                            if (!(option instanceof Some)) break block2;
                            Some some = (Some)option;
                            Try res = (Try)some.x();
                            future = Future$.MODULE$.fromTry(res);
                            break block3;
                        }
                        if (!None$.MODULE$.equals(option)) break block4;
                        future = (Future)this.fallback$1.apply();
                    }
                    return future;
                }
                throw new MatchError(option);
            }
            {
                this.fallback$1 = fallback$1;
            }
        }, (ExecutionContext)s);
    }

    public <A> Future<Try<A>> materialize(Future<A> source, ExecutionContext ec) {
        Future future;
        if (source.isCompleted()) {
            future = Future$.MODULE$.successful(source.value().get());
        } else {
            Promise p = Promise$.MODULE$.apply();
            source.onComplete((Function1)new Serializable(p){
                public static final long serialVersionUID = 0L;
                private final Promise p$1;

                public final Promise<Try<A>> apply(Try<A> value) {
                    return this.p$1.success(value);
                }
                {
                    this.p$1 = p$1;
                }
            }, (ExecutionContext)TrampolineExecutionContext$.MODULE$.immediate());
            future = p.future();
        }
        return future;
    }

    public <A, B> Future<B> transform(Future<A> source, Function1<Try<A>, Try<B>> f, ExecutionContext ec) {
        Future future;
        Future<A> future2 = source;
        if (future2 instanceof CancelableFuture) {
            CancelableFuture cancelableFuture = (CancelableFuture)future2;
            future = cancelableFuture.transform(f, ec);
        } else {
            Promise p = Promise$.MODULE$.apply();
            source.onComplete((Function1)new Serializable(f, p){
                public static final long serialVersionUID = 0L;
                private final Function1 f$1;
                private final Promise p$2;

                public final Promise<B> apply(Try<A> result) {
                    Throwable throwable2;
                    block2: {
                        Try try_;
                        try {
                            try_ = (Try)this.f$1.apply(result);
                        }
                        catch (Throwable throwable2) {
                            Throwable throwable3 = throwable2;
                            if (!NonFatal$.MODULE$.apply(throwable3)) break block2;
                            Failure failure = new Failure(throwable3);
                            try_ = failure;
                        }
                        Try b = try_;
                        return this.p$2.complete(b);
                    }
                    throw throwable2;
                }
                {
                    this.f$1 = f$1;
                    this.p$2 = p$2;
                }
            }, ec);
            future = p.future();
        }
        return future;
    }

    public <A, B> Future<B> transformWith(Future<A> source, Function1<Try<A>, Future<B>> f, ExecutionContext ec) {
        Future<B> future;
        Future<A> future2 = source;
        if (future2 instanceof CancelableFuture) {
            CancelableFuture cancelableFuture = (CancelableFuture)future2;
            future = cancelableFuture.transformWith(f, ec);
        } else {
            future = MonixInternals$.MODULE$.transformWith(source, f, ec);
        }
        return future;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <A> Future<A> dematerialize(Future<Try<A>> source, ExecutionContext ec) {
        Future future;
        if (source.isCompleted()) {
            Future future2;
            Try try_ = (Try)source.value().get();
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable error = failure.exception();
                future2 = Future$.MODULE$.failed(error);
            } else {
                Future future3;
                if (!(try_ instanceof Success)) throw new MatchError((Object)try_);
                Success success = (Success)try_;
                Try value = (Try)success.value();
                Try try_2 = value;
                if (try_2 instanceof Success) {
                    Success success2 = (Success)try_2;
                    Object success3 = success2.value();
                    future3 = Future$.MODULE$.successful(success3);
                } else {
                    if (!(try_2 instanceof Failure)) throw new MatchError((Object)try_2);
                    Failure failure = (Failure)try_2;
                    Throwable error = failure.exception();
                    future3 = Future$.MODULE$.failed(error);
                }
                future2 = future3;
            }
            future = future2;
            return future;
        } else {
            Promise p = Promise$.MODULE$.apply();
            source.onComplete((Function1)new Serializable(p){
                public static final long serialVersionUID = 0L;
                private final Promise p$3;

                public final Promise<A> apply(Try<Try<A>> x0$2) {
                    Try<Try<A>> try_;
                    block4: {
                        Promise promise;
                        block3: {
                            block2: {
                                try_ = x0$2;
                                if (!(try_ instanceof Failure)) break block2;
                                Failure failure = (Failure)try_;
                                Throwable error = failure.exception();
                                promise = this.p$3.failure(error);
                                break block3;
                            }
                            if (!(try_ instanceof Success)) break block4;
                            Success success = (Success)try_;
                            Try result = (Try)success.value();
                            promise = this.p$3.complete(result);
                        }
                        return promise;
                    }
                    throw new MatchError(try_);
                }
                {
                    this.p$3 = p$3;
                }
            }, (ExecutionContext)TrampolineExecutionContext$.MODULE$.immediate());
            future = p.future();
        }
        return future;
    }

    public <A> Future<A> delayedResult(FiniteDuration delay, Function0<A> result, Scheduler s) {
        Promise p = Promise$.MODULE$.apply();
        s.scheduleOnce(delay.length(), delay.unit(), new Runnable(result, p){
            private final Function0 result$1;
            private final Promise p$4;

            public void run() {
                this.p$4.complete(Try$.MODULE$.apply(this.result$1));
            }
            {
                this.result$1 = result$1;
                this.p$4 = p$4;
            }
        });
        return p.future();
    }

    private FutureUtils$() {
        MODULE$ = this;
    }
}

