/*
 * Decompiled with CFR 0.152.
 */
package monix.execution.internal.atomic;

import java.lang.reflect.Field;
import monix.execution.internal.InternalApi;
import monix.execution.internal.atomic.BoxedObject;
import monix.execution.internal.atomic.UnsafeAccess;
import sun.misc.Unsafe;

@InternalApi
final class NormalJava8BoxedObject
implements BoxedObject {
    public volatile Object value;
    private static final long OFFSET;
    private static final Unsafe UNSAFE;

    NormalJava8BoxedObject(Object object) {
        this.value = object;
    }

    @Override
    public Object volatileGet() {
        return this.value;
    }

    @Override
    public void volatileSet(Object object) {
        this.value = object;
    }

    @Override
    public void lazySet(Object object) {
        UNSAFE.putOrderedObject(this, OFFSET, object);
    }

    @Override
    public boolean compareAndSet(Object object, Object object2) {
        return UNSAFE.compareAndSwapObject(this, OFFSET, object, object2);
    }

    @Override
    public Object getAndSet(Object object) {
        return UNSAFE.getAndSetObject(this, OFFSET, object);
    }

    static {
        UNSAFE = (Unsafe)UnsafeAccess.getInstance();
        try {
            Field field = NormalJava8BoxedObject.class.getDeclaredField("value");
            OFFSET = UNSAFE.objectFieldOffset(field);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

