/*
 * Decompiled with CFR 0.152.
 */
package monix.execution.atomic.boxes.right128Java7;

import java.lang.reflect.Field;
import monix.execution.atomic.boxes.BoxedLong;
import monix.execution.misc.UnsafeAccess;

abstract class BoxedLongImpl
implements BoxedLong {
    public volatile long value;
    public static final long OFFSET;

    public BoxedLongImpl(long l) {
        this.value = l;
    }

    @Override
    public long volatileGet() {
        return this.value;
    }

    @Override
    public void volatileSet(long l) {
        this.value = l;
    }

    @Override
    public void lazySet(long l) {
        UnsafeAccess.UNSAFE.putOrderedLong(this, OFFSET, l);
    }

    @Override
    public boolean compareAndSet(long l, long l2) {
        return UnsafeAccess.UNSAFE.compareAndSwapLong(this, OFFSET, l, l2);
    }

    @Override
    public long getAndSet(long l) {
        long l2 = this.value;
        while (!UnsafeAccess.UNSAFE.compareAndSwapLong(this, OFFSET, l2, l)) {
            l2 = this.value;
        }
        return l2;
    }

    static {
        try {
            Field field = BoxedLongImpl.class.getDeclaredField("value");
            OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(field);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

