/*
 * Decompiled with CFR 0.152.
 */
package monix.execution;

import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import monix.execution.Cancelable;
import monix.execution.Scheduler;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public final class FutureUtils$ {
    public static FutureUtils$ MODULE$;

    static {
        new FutureUtils$();
    }

    public <T> Future<T> timeout(Future<T> source, FiniteDuration atMost, Scheduler s) {
        TimeoutException err = new TimeoutException();
        Promise promise = Promise$.MODULE$.apply();
        Cancelable task = s.scheduleOnce(atMost.length(), atMost.unit(), new Runnable(err, promise){
            private final TimeoutException err$1;
            private final Promise promise$1;

            public void run() {
                this.promise$1.tryFailure((Throwable)this.err$1);
            }
            {
                this.err$1 = err$1;
                this.promise$1 = promise$1;
            }
        });
        source.onComplete((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)FutureUtils$.$anonfun$timeout$1(promise, task, r)), (ExecutionContext)s);
        return promise.future();
    }

    public <T> Future<T> timeoutTo(Future<T> source, FiniteDuration atMost, Function0<Future<T>> fallback, Scheduler s) {
        Promise promise = Promise$.MODULE$.apply();
        Cancelable task = s.scheduleOnce(atMost.length(), atMost.unit(), new Runnable(fallback, promise){
            private final Function0 fallback$1;
            private final Promise promise$2;

            public void run() {
                this.promise$2.tryCompleteWith((Future)this.fallback$1.apply());
            }
            {
                this.fallback$1 = fallback$1;
                this.promise$2 = promise$2;
            }
        });
        source.onComplete((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)FutureUtils$.$anonfun$timeoutTo$1(promise, task, r)), (ExecutionContext)s);
        return promise.future();
    }

    public <T> Future<Try<T>> materialize(Future<T> source, ExecutionContext ec) {
        Future future;
        if (source.isCompleted()) {
            future = Future$.MODULE$.successful(source.value().get());
        } else {
            Promise p = Promise$.MODULE$.apply();
            source.onComplete((Function1 & Serializable & scala.Serializable)result -> p.success(result), ec);
            future = p.future();
        }
        return future;
    }

    public <T, S> Future<S> transform(Future<T> source, Function1<Try<T>, Try<S>> f, ExecutionContext ec) {
        Promise p = Promise$.MODULE$.apply();
        source.onComplete((Function1 & Serializable & scala.Serializable)r -> {
            Promise promise;
            try {
                promise = p.complete((Try)f.apply(r));
            }
            catch (Throwable throwable) {
                BoxedUnit boxedUnit;
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable ex = (Throwable)option.get();
                    if (!p.tryFailure(ex)) {
                        ec.reportFailure(ex);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    throw throwable;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
                promise = boxedUnit2;
            }
            return promise;
        }, ec);
        return p.future();
    }

    public <T, S> Future<S> transformWith(Future<T> source, Function1<Try<T>, Future<S>> f, ExecutionContext ec) {
        Promise p = Promise$.MODULE$.apply();
        source.onComplete((Function1 & Serializable & scala.Serializable)r -> {
            Promise promise;
            try {
                promise = p.completeWith((Future)f.apply(r));
            }
            catch (Throwable throwable) {
                BoxedUnit boxedUnit;
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable ex = (Throwable)option.get();
                    if (!p.tryFailure(ex)) {
                        ec.reportFailure(ex);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    throw throwable;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
                promise = boxedUnit2;
            }
            return promise;
        }, ec);
        return p.future();
    }

    public <T> Future<T> dematerialize(Future<Try<T>> source, ExecutionContext ec) {
        Future future;
        if (source.isCompleted()) {
            Future future2;
            Try try_ = (Try)source.value().get();
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable error = failure.exception();
                future2 = Future$.MODULE$.failed(error);
            } else if (try_ instanceof Success) {
                Future future3;
                Success success = (Success)try_;
                Try value = (Try)success.value();
                Try try_2 = value;
                if (try_2 instanceof Success) {
                    Success success2 = (Success)try_2;
                    Object success3 = success2.value();
                    future3 = Future$.MODULE$.successful(success3);
                } else if (try_2 instanceof Failure) {
                    Failure failure = (Failure)try_2;
                    Throwable error = failure.exception();
                    future3 = Future$.MODULE$.failed(error);
                } else {
                    throw new MatchError((Object)try_2);
                }
                future2 = future3;
            } else {
                throw new MatchError((Object)try_);
            }
            future = future2;
        } else {
            Promise p = Promise$.MODULE$.apply();
            source.onComplete((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Promise promise;
                Try try_ = x0$1;
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable error = failure.exception();
                    promise = p.failure(error);
                } else if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    Try result = (Try)success.value();
                    promise = p.complete(result);
                } else {
                    throw new MatchError((Object)try_);
                }
                return promise;
            }, ec);
            future = p.future();
        }
        return future;
    }

    public <T> Future<T> delayedResult(FiniteDuration delay, Function0<T> result, Scheduler s) {
        Promise p = Promise$.MODULE$.apply();
        s.scheduleOnce(delay.length(), delay.unit(), new Runnable(result, p){
            private final Function0 result$1;
            private final Promise p$5;

            public void run() {
                this.p$5.complete(Try$.MODULE$.apply(this.result$1));
            }
            {
                this.result$1 = result$1;
                this.p$5 = p$5;
            }
        });
        return p.future();
    }

    public static final /* synthetic */ boolean $anonfun$timeout$1(Promise promise$1, Cancelable task$1, Try r) {
        task$1.cancel();
        return promise$1.tryComplete(r);
    }

    public static final /* synthetic */ boolean $anonfun$timeoutTo$1(Promise promise$2, Cancelable task$2, Try r) {
        task$2.cancel();
        return promise$2.tryComplete(r);
    }

    private FutureUtils$() {
        MODULE$ = this;
    }
}

