/*
 * Decompiled with CFR 0.152.
 */
package monix.execution.internals.atomic;

import java.lang.reflect.Field;
import monix.execution.internals.atomic.BoxedLong;
import monix.execution.internals.atomic.LeftPadding120;
import monix.execution.internals.atomic.UnsafeAccess;
import sun.misc.Unsafe;

final class Left128Java8BoxedLong
extends LeftPadding120
implements BoxedLong {
    public volatile long value;
    private static final long OFFSET;
    private static final Unsafe UNSAFE;

    Left128Java8BoxedLong(long l) {
        this.value = l;
    }

    @Override
    public long volatileGet() {
        return this.value;
    }

    @Override
    public void volatileSet(long l) {
        this.value = l;
    }

    @Override
    public void lazySet(long l) {
        UNSAFE.putOrderedLong(this, OFFSET, l);
    }

    @Override
    public boolean compareAndSet(long l, long l2) {
        return UNSAFE.compareAndSwapLong(this, OFFSET, l, l2);
    }

    @Override
    public long getAndSet(long l) {
        return UNSAFE.getAndSetLong(this, OFFSET, l);
    }

    @Override
    public long getAndAdd(long l) {
        return UNSAFE.getAndAddLong(this, OFFSET, l);
    }

    static {
        UNSAFE = (Unsafe)UnsafeAccess.getInstance();
        try {
            Field field = Left128Java8BoxedLong.class.getDeclaredField("value");
            OFFSET = UNSAFE.objectFieldOffset(field);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

