/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.internal.builders;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import monix.execution.Ack;
import monix.execution.Ack$Continue$;
import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.execution.ExecutionModel;
import monix.execution.Scheduler;
import monix.execution.UncaughtExceptionReporter;
import monix.execution.atomic.AtomicBoolean;
import monix.execution.atomic.AtomicBuilder;
import monix.execution.atomic.PaddingStrategy;
import monix.execution.cancelables.BooleanCancelable;
import monix.execution.cancelables.BooleanCancelable$;
import monix.execution.exceptions.APIContractViolationException$;
import monix.execution.internal.Platform$;
import monix.reactive.Observable;
import monix.reactive.observers.Subscriber;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u00055d!\u0002\u0007\u000e\u0005E)\u0002\u0002C\u0012\u0001\u0005\u0003\u0005\u000b\u0011B\u0013\t\u00115\u0002!\u0011!Q\u0001\n9BQ!\r\u0001\u0005\u0002IBaa\u000e\u0001!\u0002\u0013A\u0004\"\u0002!\u0001\t\u0003\t\u0005\"\u0002(\u0001\t\u0013y\u0005\"\u0002;\u0001\t\u0013)\bbBA\u0007\u0001\u0011%\u0011q\u0002\u0005\n\u00037\u0001\u0011\u0013!C\u0005\u0003;Aq!a\f\u0001\t\u0013\t\t\u0004C\u0004\u0002d\u0001!I!!\u001a\u0003+%s\u0007/\u001e;TiJ,\u0017-\\(cg\u0016\u0014h/\u00192mK*\u0011abD\u0001\tEVLG\u000eZ3sg*\u0011\u0001#E\u0001\tS:$XM\u001d8bY*\u0011!cE\u0001\te\u0016\f7\r^5wK*\tA#A\u0003n_:L\u0007p\u0005\u0002\u0001-A\u0019q\u0003\u0007\u000e\u000e\u0003EI!!G\t\u0003\u0015=\u00137/\u001a:wC\ndW\rE\u0002\u001c=\u0001j\u0011\u0001\b\u0006\u0002;\u0005)1oY1mC&\u0011q\u0004\b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u00037\u0005J!A\t\u000f\u0003\t\tKH/Z\u0001\u0003S:\u001c\u0001\u0001\u0005\u0002'W5\tqE\u0003\u0002)S\u0005\u0011\u0011n\u001c\u0006\u0002U\u0005!!.\u0019<b\u0013\tasEA\u0006J]B,Ho\u0015;sK\u0006l\u0017!C2ik:\\7+\u001b>f!\tYr&\u0003\u000219\t\u0019\u0011J\u001c;\u0002\rqJg.\u001b;?)\r\u0019TG\u000e\t\u0003i\u0001i\u0011!\u0004\u0005\u0006G\r\u0001\r!\n\u0005\u0006[\r\u0001\rAL\u0001\u000eo\u0006\u001c8+\u001e2tGJL'-\u001a3\u0011\u0005erT\"\u0001\u001e\u000b\u0005mb\u0014AB1u_6L7M\u0003\u0002>'\u0005IQ\r_3dkRLwN\\\u0005\u0003\u007fi\u0012Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017!E;og\u00064WmU;cg\u000e\u0014\u0018NY3G]R\u0011!I\u0012\t\u0003\u0007\u0012k\u0011\u0001P\u0005\u0003\u000br\u0012!bQ1oG\u0016d\u0017M\u00197f\u0011\u00159U\u00011\u0001I\u0003\ryW\u000f\u001e\t\u0004\u00132SR\"\u0001&\u000b\u0005-\u000b\u0012!C8cg\u0016\u0014h/\u001a:t\u0013\ti%J\u0001\u0006Tk\n\u001c8M]5cKJ\f!B]3tG\",G-\u001e7f)\u0019\u0001\u0016\f\u001a4h_R\u0011\u0011\u000b\u0016\t\u00037IK!a\u0015\u000f\u0003\tUs\u0017\u000e\u001e\u0005\u0006+\u001a\u0001\u001dAV\u0001\u0002gB\u00111iV\u0005\u00031r\u0012\u0011bU2iK\u0012,H.\u001a:\t\u000bi3\u0001\u0019A.\u0002\u0007\u0005\u001c7\u000eE\u0002]?\u0006l\u0011!\u0018\u0006\u0003=r\t!bY8oGV\u0014(/\u001a8u\u0013\t\u0001WL\u0001\u0004GkR,(/\u001a\t\u0003\u0007\nL!a\u0019\u001f\u0003\u0007\u0005\u001b7\u000eC\u0003f\r\u0001\u0007!$A\u0001c\u0011\u00159e\u00011\u0001I\u0011\u0015Ag\u00011\u0001j\u0003\u0005\u0019\u0007C\u00016n\u001b\u0005Y'B\u00017=\u0003-\u0019\u0017M\\2fY\u0006\u0014G.Z:\n\u00059\\'!\u0005\"p_2,\u0017M\\\"b]\u000e,G.\u00192mK\")\u0001O\u0002a\u0001c\u0006\u0011Q-\u001c\t\u0003\u0007JL!a\u001d\u001f\u0003\u001d\u0015CXmY;uS>tWj\u001c3fY\u0006Aa-Y:u\u0019>|\u0007\u000f\u0006\u0004wqj\\H0 \u000b\u0003#^DQ!V\u0004A\u0004YCQ!_\u0004A\u0002i\taAY;gM\u0016\u0014\b\"B$\b\u0001\u0004A\u0005\"\u00025\b\u0001\u0004I\u0007\"\u00029\b\u0001\u0004\t\b\"\u0002@\b\u0001\u0004q\u0013!C:z]\u000eLe\u000eZ3yQ\r9\u0011\u0011\u0001\t\u0005\u0003\u0007\tI!\u0004\u0002\u0002\u0006)\u0019\u0011q\u0001\u000f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\f\u0005\u0015!a\u0002;bS2\u0014XmY\u0001\u000bM&dGNQ;gM\u0016\u0014Hc\u0002\u0018\u0002\u0012\u0005M\u0011Q\u0003\u0005\u0006G!\u0001\r!\n\u0005\u0006s\"\u0001\rA\u0007\u0005\t\u0003/A\u0001\u0013!a\u0001]\u0005ya\u000eV8uC2\u0014\u0015\u0010^3t%\u0016\fG\rK\u0002\t\u0003\u0003\tACZ5mY\n+hMZ3sI\u0011,g-Y;mi\u0012\u001aTCAA\u0010U\rq\u0013\u0011E\u0016\u0003\u0003G\u0001B!!\n\u0002,5\u0011\u0011q\u0005\u0006\u0005\u0003S\t)!A\u0005v]\u000eDWmY6fI&!\u0011QFA\u0014\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\ng\u0016tG-\u0012:s_J$b!a\r\u0002>\u0005\u001dCcA)\u00026!1QK\u0003a\u0002\u0003o\u00012aQA\u001d\u0013\r\tY\u0004\u0010\u0002\u001a+:\u001c\u0017-^4ii\u0016C8-\u001a9uS>t'+\u001a9peR,'\u000f\u0003\u0004H\u0015\u0001\u0007\u0011q\b\t\u0005\u00132\u000b\t\u0005E\u0002\u001c\u0003\u0007J1!!\u0012\u001d\u0005\u001dqu\u000e\u001e5j]\u001eDq!!\u0013\u000b\u0001\u0004\tY%A\u0001f!\u0011\ti%!\u0018\u000f\t\u0005=\u0013\u0011\f\b\u0005\u0003#\n9&\u0004\u0002\u0002T)\u0019\u0011Q\u000b\u0013\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0012bAA.9\u00059\u0001/Y2lC\u001e,\u0017\u0002BA0\u0003C\u0012\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\u0005mC$A\u0007sKB|'\u000f\u001e$bS2,(/\u001a\u000b\u0005\u0003O\nY\u0007F\u0002R\u0003SBa!V\u0006A\u0004\u0005]\u0002bBA%\u0017\u0001\u0007\u00111\n")
public final class InputStreamObservable
extends Observable<byte[]> {
    private final InputStream in;
    private final int chunkSize;
    private final AtomicBoolean wasSubscribed;
    private volatile boolean bitmap$init$0;

    /*
     * WARNING - void declaration
     */
    @Override
    public Cancelable unsafeSubscribeFn(Subscriber<byte[]> out) {
        Cancelable cancelable;
        if (this.wasSubscribed.compareAndSet(false, true)) {
            void var3_3;
            byte[] buffer = new byte[this.chunkSize];
            BooleanCancelable cancelable2 = BooleanCancelable$.MODULE$.apply();
            ExecutionModel em = out.scheduler().executionModel();
            this.reschedule((Future<Ack>)Ack$Continue$.MODULE$, buffer, out, cancelable2, em, out.scheduler());
            cancelable = var3_3;
        } else {
            out.onError((Throwable)APIContractViolationException$.MODULE$.apply("InputStreamObservable does not support multiple subscribers"));
            cancelable = Cancelable$.MODULE$.empty();
        }
        return cancelable;
    }

    private void reschedule(Future<Ack> ack, byte[] b, Subscriber<byte[]> out, BooleanCancelable c, ExecutionModel em, Scheduler s) {
        ack.onComplete((Function1 & Serializable)x0$1 -> {
            InputStreamObservable.$anonfun$reschedule$1(this, c, b, out, em, s, x0$1);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)s);
    }

    private void fastLoop(byte[] buffer, Subscriber<byte[]> out, BooleanCancelable c, ExecutionModel em, int syncIndex, Scheduler s) {
        block12: {
            BoxedUnit boxedUnit;
            boolean streamErrors;
            Throwable errorThrown;
            block11: {
                Ack$Continue$ ack;
                while (true) {
                    int nextIndex;
                    int n;
                    errorThrown = null;
                    ack = Ack$Continue$.MODULE$;
                    streamErrors = true;
                    try {
                        Future<Ack> future;
                        int length = this.fillBuffer(this.in, buffer, this.fillBuffer$default$3());
                        streamErrors = false;
                        if (length >= 0) {
                            byte[] next = Arrays.copyOf(buffer, length);
                            future = out.onNext(next);
                        } else {
                            out.onComplete();
                            future = Ack.Stop$.MODULE$;
                        }
                        ack = future;
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (NonFatal$.MODULE$.apply(throwable2)) {
                            errorThrown = throwable2;
                            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                        }
                        throw throwable;
                    }
                    if (errorThrown != null) break block11;
                    Ack$Continue$ ack$Continue$ = ack;
                    Ack$Continue$ ack$Continue$2 = Ack$Continue$.MODULE$;
                    if (!(ack$Continue$ != null ? !ack$Continue$.equals(ack$Continue$2) : ack$Continue$2 != null)) {
                        n = em.nextFrameIndex(syncIndex);
                    } else {
                        Ack$Continue$ ack$Continue$3 = ack;
                        Ack.Stop$ stop$ = Ack.Stop$.MODULE$;
                        n = !(ack$Continue$3 != null ? !ack$Continue$3.equals(stop$) : stop$ != null) ? -1 : (nextIndex = 0);
                    }
                    if (nextIndex < 0 || c.isCanceled()) {
                        boxedUnit = BoxedUnit.UNIT;
                        break block12;
                    }
                    if (nextIndex <= 0) break;
                    syncIndex = nextIndex;
                }
                this.reschedule((Future<Ack>)ack, buffer, out, c, em, s);
                boxedUnit = BoxedUnit.UNIT;
                break block12;
            }
            if (streamErrors) {
                this.sendError(out, errorThrown, (UncaughtExceptionReporter)s);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.reportFailure(errorThrown, (UncaughtExceptionReporter)s);
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    private int fillBuffer(InputStream in, byte[] buffer, int nTotalBytesRead) {
        int n;
        block2: {
            int nBytesRead;
            while (true) {
                if (nTotalBytesRead >= buffer.length) {
                    n = nTotalBytesRead;
                    break block2;
                }
                nBytesRead = in.read(buffer, nTotalBytesRead, buffer.length - nTotalBytesRead);
                if (nBytesRead < 0) break;
                nTotalBytesRead += nBytesRead;
            }
            n = nTotalBytesRead <= 0 ? nBytesRead : nTotalBytesRead;
        }
        return n;
    }

    private int fillBuffer$default$3() {
        return 0;
    }

    private void sendError(Subscriber<Nothing$> out, Throwable e, UncaughtExceptionReporter s) {
        try {
            out.onError(e);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e2 = (Throwable)option.get();
                this.reportFailure(Platform$.MODULE$.composeErrors(e, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Throwable[]{e2})), s);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    private void reportFailure(Throwable e, UncaughtExceptionReporter s) {
        s.reportFailure(e);
        try {
            this.in.close();
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    public static final /* synthetic */ void $anonfun$reschedule$1(InputStreamObservable $this, BooleanCancelable c$1, byte[] b$1, Subscriber out$1, ExecutionModel em$1, Scheduler s$1, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Success) {
            Ack next;
            Success success = (Success)try_;
            Ack ack = next = (Ack)success.value();
            Ack$Continue$ ack$Continue$ = Ack$Continue$.MODULE$;
            BoxedUnit boxedUnit = !(ack != null ? !ack.equals(ack$Continue$) : ack$Continue$ != null) && !c$1.isCanceled() ? (BoxedUnit)package$.MODULE$.blocking((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.fastLoop(b$1, out$1, c$1, em$1, 0, s$1)) : BoxedUnit.UNIT;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            $this.reportFailure(ex, (UncaughtExceptionReporter)s$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public InputStreamObservable(InputStream in, int chunkSize) {
        this.in = in;
        this.chunkSize = chunkSize;
        Predef$.MODULE$.require(chunkSize > 0, (Function0 & Serializable)() -> "chunkSize > 0");
        this.wasSubscribed = AtomicBuilder.AtomicBooleanBuilder$.MODULE$.buildInstance(false, (PaddingStrategy)PaddingStrategy.NoPadding$.MODULE$, true);
        this.bitmap$init$0 = true;
    }
}

