/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.observers.buffers;

import monix.execution.internal.collection.ArrayQueue;
import monix.execution.internal.collection.ArrayQueue$;
import monix.execution.internal.collection.DropAllOnOverflowQueue;
import monix.execution.internal.collection.DropAllOnOverflowQueue$;
import monix.execution.internal.collection.DropHeadOnOverflowQueue;
import monix.execution.internal.collection.DropHeadOnOverflowQueue$;
import monix.reactive.exceptions.BufferOverflowException;
import monix.reactive.observers.Subscriber;
import monix.reactive.observers.SyncSubscriber;
import monix.reactive.observers.buffers.SyncBufferedSubscriber;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;

public final class SyncBufferedSubscriber$ {
    public static final SyncBufferedSubscriber$ MODULE$;

    static {
        new SyncBufferedSubscriber$();
    }

    public <T> SyncSubscriber<T> unbounded(Subscriber<T> underlying) {
        ArrayQueue buffer = ArrayQueue$.MODULE$.unbounded();
        return new SyncBufferedSubscriber<T>(underlying, buffer, null);
    }

    public <T> SyncSubscriber<T> bounded(Subscriber<T> underlying, int bufferSize) {
        Predef$.MODULE$.require(bufferSize > 1, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "bufferSize must be a strictly positive number, bigger than 1";
            }
        });
        ArrayQueue buffer = ArrayQueue$.MODULE$.bounded(bufferSize, (Function1)new Serializable(bufferSize){
            public static final long serialVersionUID = 0L;
            private final int bufferSize$1;

            public final BufferOverflowException apply(int capacity) {
                return new BufferOverflowException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Downstream observer is too slow, buffer over capacity with a "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"specified buffer size of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.bufferSize$1)}))).toString());
            }
            {
                this.bufferSize$1 = bufferSize$1;
            }
        });
        return new SyncBufferedSubscriber<T>(underlying, buffer, null);
    }

    public <T> SyncSubscriber<T> dropNew(Subscriber<T> underlying, int bufferSize) {
        Predef$.MODULE$.require(bufferSize > 1, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "bufferSize must be a strictly positive number, bigger than 1";
            }
        });
        ArrayQueue buffer = ArrayQueue$.MODULE$.bounded(bufferSize, ArrayQueue$.MODULE$.bounded$default$2());
        return new SyncBufferedSubscriber<T>(underlying, buffer, null);
    }

    public <T> SyncSubscriber<T> dropNewAndSignal(Subscriber<T> underlying, int bufferSize, Function1<Object, T> onOverflow) {
        Predef$.MODULE$.require(bufferSize > 1, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "bufferSize must be a strictly positive number, bigger than 1";
            }
        });
        ArrayQueue buffer = ArrayQueue$.MODULE$.bounded(bufferSize, ArrayQueue$.MODULE$.bounded$default$2());
        return new SyncBufferedSubscriber<T>(underlying, buffer, onOverflow);
    }

    public <T> SyncSubscriber<T> dropOld(Subscriber<T> underlying, int bufferSize) {
        Predef$.MODULE$.require(bufferSize > 1, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "bufferSize must be a strictly positive number, bigger than 1";
            }
        });
        DropHeadOnOverflowQueue buffer = DropHeadOnOverflowQueue$.MODULE$.apply(bufferSize, ClassTag$.MODULE$.AnyRef());
        return new SyncBufferedSubscriber<T>(underlying, buffer, null);
    }

    public <T> SyncSubscriber<T> dropOldAndSignal(Subscriber<T> underlying, int bufferSize, Function1<Object, T> onOverflow) {
        Predef$.MODULE$.require(bufferSize > 1, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "bufferSize must be a strictly positive number, bigger than 1";
            }
        });
        DropHeadOnOverflowQueue buffer = DropHeadOnOverflowQueue$.MODULE$.apply(bufferSize, ClassTag$.MODULE$.AnyRef());
        return new SyncBufferedSubscriber<T>(underlying, buffer, onOverflow);
    }

    public <T> SyncSubscriber<T> clearBuffer(Subscriber<T> underlying, int bufferSize) {
        Predef$.MODULE$.require(bufferSize > 1, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "bufferSize must be a strictly positive number, bigger than 1";
            }
        });
        DropAllOnOverflowQueue buffer = DropAllOnOverflowQueue$.MODULE$.apply(bufferSize, ClassTag$.MODULE$.AnyRef());
        return new SyncBufferedSubscriber<T>(underlying, buffer, null);
    }

    public <T> SyncSubscriber<T> clearBufferAndSignal(Subscriber<T> underlying, int bufferSize, Function1<Object, T> onOverflow) {
        Predef$.MODULE$.require(bufferSize > 1, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "bufferSize must be a strictly positive number, bigger than 1";
            }
        });
        DropAllOnOverflowQueue buffer = DropAllOnOverflowQueue$.MODULE$.apply(bufferSize, ClassTag$.MODULE$.AnyRef());
        return new SyncBufferedSubscriber<T>(underlying, buffer, onOverflow);
    }

    private <T> Null$ $lessinit$greater$default$3() {
        return null;
    }

    private SyncBufferedSubscriber$() {
        MODULE$ = this;
    }
}

