/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.registration.processor.rest.client.audit.builder;

import io.mosip.kernel.core.util.DateUtils;
import io.mosip.registration.processor.core.code.ApiName;
import io.mosip.registration.processor.core.code.AuditLogConstant;
import io.mosip.registration.processor.core.constant.LoggerFileConstant;
import io.mosip.registration.processor.core.exception.ApisResourceAccessException;
import io.mosip.registration.processor.core.http.RequestWrapper;
import io.mosip.registration.processor.core.http.ResponseWrapper;
import io.mosip.registration.processor.core.spi.restclient.RegistrationProcessorRestClientService;
import io.mosip.registration.processor.core.util.ServerUtil;
import io.mosip.registration.processor.rest.client.audit.dto.AuditRequestDto;
import io.mosip.registration.processor.rest.client.audit.dto.AuditResponseDto;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class AuditLogRequestBuilder {
    private final Logger regProcLogger = LoggerFactory.getLogger(AuditLogRequestBuilder.class);
    @Autowired
    private RegistrationProcessorRestClientService<Object> registrationProcessorRestService;
    @Autowired
    private Environment env;
    private static final String AUDIT_SERVICE_ID = "mosip.registration.processor.audit.id";
    private static final String REG_PROC_APPLICATION_VERSION = "mosip.registration.processor.application.version";
    private static final String DATETIME_PATTERN = "mosip.registration.processor.datetime.pattern";

    public ResponseWrapper<AuditResponseDto> createAuditRequestBuilder(String description, String eventId, String eventName, String eventType, String registrationId, ApiName apiname) {
        this.regProcLogger.debug(LoggerFileConstant.SESSIONID.toString(), new Object[]{LoggerFileConstant.REGISTRATIONID.toString(), registrationId, "AuditLogRequestBuilder:: createAuditRequestBuilder(String description, String eventId, String eventName, String eventType,\r\n\t\t\tString registrationId, ApiName apiname)::entry"});
        AuditRequestDto auditRequestDto = new AuditRequestDto();
        RequestWrapper requestWrapper = new RequestWrapper();
        ResponseWrapper responseWrapper = new ResponseWrapper();
        try {
            auditRequestDto.setDescription(description);
            auditRequestDto.setActionTimeStamp(DateUtils.getUTCCurrentDateTimeString((String)this.env.getProperty(DATETIME_PATTERN)));
            auditRequestDto.setApplicationId(AuditLogConstant.MOSIP_4.toString());
            auditRequestDto.setApplicationName(AuditLogConstant.REGISTRATION_PROCESSOR.toString());
            auditRequestDto.setCreatedBy(AuditLogConstant.SYSTEM.toString());
            auditRequestDto.setEventId(eventId);
            auditRequestDto.setEventName(eventName);
            auditRequestDto.setEventType(eventType);
            auditRequestDto.setHostIp(ServerUtil.getServerUtilInstance().getServerIp());
            auditRequestDto.setHostName(ServerUtil.getServerUtilInstance().getServerName());
            auditRequestDto.setId(registrationId);
            auditRequestDto.setIdType(AuditLogConstant.REGISTRATION_ID.toString());
            auditRequestDto.setModuleId(null);
            auditRequestDto.setModuleName(null);
            auditRequestDto.setSessionUserId(AuditLogConstant.SYSTEM.toString());
            auditRequestDto.setSessionUserName(null);
            requestWrapper.setId(this.env.getProperty(AUDIT_SERVICE_ID));
            requestWrapper.setMetadata(null);
            requestWrapper.setRequest((Object)auditRequestDto);
            DateTimeFormatter format = DateTimeFormatter.ofPattern(this.env.getProperty(DATETIME_PATTERN));
            LocalDateTime localdatetime = LocalDateTime.parse(DateUtils.getUTCCurrentDateTimeString((String)this.env.getProperty(DATETIME_PATTERN)), format);
            requestWrapper.setRequesttime(localdatetime);
            requestWrapper.setVersion(this.env.getProperty(REG_PROC_APPLICATION_VERSION));
            responseWrapper = (ResponseWrapper)this.registrationProcessorRestService.postApi(apiname, "", "", (Object)requestWrapper, ResponseWrapper.class);
        }
        catch (ApisResourceAccessException arae) {
            this.regProcLogger.error(arae.getMessage());
        }
        this.regProcLogger.debug(LoggerFileConstant.SESSIONID.toString(), new Object[]{LoggerFileConstant.REGISTRATIONID.toString(), registrationId, "AuditLogRequestBuilder:: createAuditRequestBuilder(String description, String eventId, String eventName, String eventType,\r\n\t\t\tString registrationId, ApiName apiname)::exit"});
        return responseWrapper;
    }

    public ResponseWrapper<AuditResponseDto> createAuditRequestBuilder(String description, String eventId, String eventName, String eventType, String moduleId, String moduleName, String registrationId) {
        this.regProcLogger.debug(LoggerFileConstant.SESSIONID.toString(), new Object[]{LoggerFileConstant.REGISTRATIONID.toString(), registrationId, "AuditLogRequestBuilder:: createAuditRequestBuilder(String description, String eventId, String eventName, String eventType,String moduleId,String moduleName,\r\n\t\t\tString registrationId)::entry"});
        RequestWrapper requestWrapper = new RequestWrapper();
        ResponseWrapper responseWrapper = new ResponseWrapper();
        try {
            AuditRequestDto auditRequestDto = new AuditRequestDto();
            auditRequestDto.setDescription(description);
            auditRequestDto.setActionTimeStamp(DateUtils.getUTCCurrentDateTimeString((String)this.env.getProperty(DATETIME_PATTERN)));
            auditRequestDto.setApplicationId(AuditLogConstant.MOSIP_4.toString());
            auditRequestDto.setApplicationName(AuditLogConstant.REGISTRATION_PROCESSOR.toString());
            auditRequestDto.setCreatedBy(AuditLogConstant.SYSTEM.toString());
            auditRequestDto.setEventId(eventId);
            auditRequestDto.setEventName(eventName);
            auditRequestDto.setEventType(eventType);
            auditRequestDto.setHostIp(ServerUtil.getServerUtilInstance().getServerIp());
            auditRequestDto.setHostName(ServerUtil.getServerUtilInstance().getServerName());
            auditRequestDto.setId(registrationId);
            auditRequestDto.setIdType(AuditLogConstant.REGISTRATION_ID.toString());
            auditRequestDto.setModuleId(moduleId);
            auditRequestDto.setModuleName(moduleName);
            auditRequestDto.setSessionUserId(AuditLogConstant.SYSTEM.toString());
            auditRequestDto.setSessionUserName(null);
            requestWrapper.setId(this.env.getProperty(AUDIT_SERVICE_ID));
            requestWrapper.setMetadata(null);
            requestWrapper.setRequest((Object)auditRequestDto);
            DateTimeFormatter format = DateTimeFormatter.ofPattern(this.env.getProperty(DATETIME_PATTERN));
            LocalDateTime localdatetime = LocalDateTime.parse(DateUtils.getUTCCurrentDateTimeString((String)this.env.getProperty(DATETIME_PATTERN)), format);
            requestWrapper.setRequesttime(localdatetime);
            requestWrapper.setVersion(this.env.getProperty(REG_PROC_APPLICATION_VERSION));
            responseWrapper = (ResponseWrapper)this.registrationProcessorRestService.postApi(ApiName.AUDIT, "", "", (Object)requestWrapper, ResponseWrapper.class);
        }
        catch (ApisResourceAccessException arae) {
            this.regProcLogger.error(arae.getMessage());
        }
        this.regProcLogger.debug(LoggerFileConstant.SESSIONID.toString(), new Object[]{LoggerFileConstant.REGISTRATIONID.toString(), registrationId, "AuditLogRequestBuilder:: createAuditRequestBuilder(String description, String eventId, String eventName, String eventType,String moduleId,String moduleName,\r\n\t\t\tString registrationId)::exit"});
        return responseWrapper;
    }
}

