/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.registration.processor.rest.client.service.impl;

import io.mosip.kernel.core.exception.ExceptionUtils;
import io.mosip.kernel.core.logger.spi.Logger;
import io.mosip.registration.processor.core.code.ApiName;
import io.mosip.registration.processor.core.constant.LoggerFileConstant;
import io.mosip.registration.processor.core.exception.ApisResourceAccessException;
import io.mosip.registration.processor.core.exception.util.PlatformErrorMessages;
import io.mosip.registration.processor.core.logger.RegProcessorLogger;
import io.mosip.registration.processor.core.spi.restclient.RegistrationProcessorRestClientService;
import io.mosip.registration.processor.rest.client.utils.RestApiClient;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class RegistrationProcessorRestClientServiceImpl
implements RegistrationProcessorRestClientService<Object> {
    private static Logger regProcLogger = RegProcessorLogger.getLogger(RegistrationProcessorRestClientServiceImpl.class);
    @Autowired
    private RestApiClient restApiClient;
    @Autowired
    private Environment env;

    public Object getApi(ApiName apiName, List<String> pathsegments, String queryParamName, String queryParamValue, Class<?> responseType) throws ApisResourceAccessException {
        regProcLogger.debug(LoggerFileConstant.SESSIONID.toString(), LoggerFileConstant.USERID.toString(), "", "RegistrationProcessorRestClientServiceImpl::getApi()::entry");
        Object obj = null;
        String apiHostIpPort = this.env.getProperty(apiName.name());
        UriComponentsBuilder builder = null;
        UriComponents uriComponents = null;
        if (apiHostIpPort != null) {
            builder = UriComponentsBuilder.fromUriString((String)apiHostIpPort);
            if (pathsegments != null && !pathsegments.isEmpty()) {
                for (String segment : pathsegments) {
                    if (segment == null || "".equals(segment)) continue;
                    builder.pathSegment(new String[]{segment});
                }
            }
            if (queryParamName != null && !"".equals(queryParamName)) {
                String[] queryParamNameArr = queryParamName.split(",");
                String[] queryParamValueArr = queryParamValue.split(",");
                for (int i = 0; i < queryParamNameArr.length; ++i) {
                    builder.queryParam(queryParamNameArr[i], new Object[]{queryParamValueArr[i]});
                }
            }
            try {
                uriComponents = builder.build(false).encode();
                regProcLogger.debug(uriComponents.toUri().toString(), "URI", "", "");
                obj = this.restApiClient.getApi(uriComponents.toUri(), responseType);
            }
            catch (Exception e) {
                e.printStackTrace();
                regProcLogger.error(LoggerFileConstant.SESSIONID.toString(), LoggerFileConstant.REGISTRATIONID.toString(), "", e.getMessage() + ExceptionUtils.getStackTrace((Throwable)e));
                throw new ApisResourceAccessException(PlatformErrorMessages.RPR_RCT_UNKNOWN_RESOURCE_EXCEPTION.getCode(), (Throwable)e);
            }
        }
        regProcLogger.debug(LoggerFileConstant.SESSIONID.toString(), LoggerFileConstant.USERID.toString(), "", "RegistrationProcessorRestClientServiceImpl::getApi()::exit");
        return obj;
    }

    public Object getApi(ApiName apiName, List<String> pathsegments, List<String> queryParamName, List<Object> queryParamValue, Class<?> responseType) throws ApisResourceAccessException {
        regProcLogger.debug(LoggerFileConstant.SESSIONID.toString(), LoggerFileConstant.USERID.toString(), "", "RegistrationProcessorRestClientServiceImpl::getApi()::entry");
        Object obj = null;
        String apiHostIpPort = this.env.getProperty(apiName.name());
        UriComponentsBuilder builder = null;
        UriComponents uriComponents = null;
        if (apiHostIpPort != null) {
            builder = UriComponentsBuilder.fromUriString((String)apiHostIpPort);
            if (pathsegments != null && !pathsegments.isEmpty()) {
                for (String segment : pathsegments) {
                    if (segment == null || "".equals(segment)) continue;
                    builder.pathSegment(new String[]{segment});
                }
            }
            if (queryParamName != null && !queryParamName.isEmpty()) {
                for (int i = 0; i < queryParamName.size(); ++i) {
                    builder.queryParam(queryParamName.get(i), new Object[]{queryParamValue.get(i)});
                }
            }
            try {
                uriComponents = builder.build(false).encode();
                regProcLogger.debug(uriComponents.toUri().toString(), "URI", "", "");
                obj = this.restApiClient.getApi(uriComponents.toUri(), responseType);
            }
            catch (Exception e) {
                e.printStackTrace();
                regProcLogger.error(LoggerFileConstant.SESSIONID.toString(), LoggerFileConstant.REGISTRATIONID.toString(), "", e.getMessage() + ExceptionUtils.getStackTrace((Throwable)e));
                throw new ApisResourceAccessException(PlatformErrorMessages.RPR_RCT_UNKNOWN_RESOURCE_EXCEPTION.getCode(), (Throwable)e);
            }
        }
        regProcLogger.debug(LoggerFileConstant.SESSIONID.toString(), LoggerFileConstant.USERID.toString(), "", "RegistrationProcessorRestClientServiceImpl::getApi()::exit");
        return obj;
    }

    public Object postApi(ApiName apiName, String queryParamName, String queryParamValue, Object requestedData, Class<?> responseType, MediaType mediaType) throws ApisResourceAccessException {
        regProcLogger.debug(LoggerFileConstant.SESSIONID.toString(), LoggerFileConstant.USERID.toString(), "", "RegistrationProcessorRestClientServiceImpl::postApi()::entry");
        Object obj = null;
        String apiHostIpPort = this.env.getProperty(apiName.name());
        UriComponentsBuilder builder = null;
        if (apiHostIpPort != null) {
            builder = UriComponentsBuilder.fromUriString((String)apiHostIpPort);
        }
        if (builder != null) {
            if (queryParamName != null && !"".equals(queryParamName)) {
                String[] queryParamNameArr = queryParamName.split(",");
                String[] queryParamValueArr = queryParamValue.split(",");
                for (int i = 0; i < queryParamNameArr.length; ++i) {
                    builder.queryParam(queryParamNameArr[i], new Object[]{queryParamValueArr[i]});
                }
            }
            try {
                obj = this.restApiClient.postApi(builder.toUriString(), mediaType, requestedData, responseType);
            }
            catch (Exception e) {
                regProcLogger.error(LoggerFileConstant.SESSIONID.toString(), LoggerFileConstant.REGISTRATIONID.toString(), "", e.getMessage() + ExceptionUtils.getStackTrace((Throwable)e));
                throw new ApisResourceAccessException(PlatformErrorMessages.RPR_RCT_UNKNOWN_RESOURCE_EXCEPTION.getMessage(), (Throwable)e);
            }
        }
        regProcLogger.debug(LoggerFileConstant.SESSIONID.toString(), LoggerFileConstant.USERID.toString(), "", "RegistrationProcessorRestClientServiceImpl::postApi()::exit");
        return obj;
    }

    public Object postApi(ApiName apiName, String queryParamName, String queryParamValue, Object requestedData, Class<?> responseType) throws ApisResourceAccessException {
        return this.postApi(apiName, queryParamName, queryParamValue, requestedData, responseType, null);
    }

    public Object postApi(ApiName apiName, List<String> pathsegments, String queryParamName, String queryParamValue, Object requestedData, Class<?> responseType) throws ApisResourceAccessException {
        regProcLogger.debug(LoggerFileConstant.SESSIONID.toString(), LoggerFileConstant.USERID.toString(), "", "RegistrationProcessorRestClientServiceImpl::postApi()::entry");
        Object obj = null;
        String apiHostIpPort = this.env.getProperty(apiName.name());
        UriComponentsBuilder builder = null;
        if (apiHostIpPort != null) {
            builder = UriComponentsBuilder.fromUriString((String)apiHostIpPort);
        }
        if (builder != null) {
            if (pathsegments != null && !pathsegments.isEmpty()) {
                for (String segment : pathsegments) {
                    if (segment == null || "".equals(segment)) continue;
                    builder.pathSegment(new String[]{segment});
                }
            }
            if (!this.checkNull(queryParamName)) {
                String[] queryParamNameArr = queryParamName.split(",");
                String[] queryParamValueArr = queryParamValue.split(",");
                for (int i = 0; i < queryParamNameArr.length; ++i) {
                    builder.queryParam(queryParamNameArr[i], new Object[]{queryParamValueArr[i]});
                }
            }
            try {
                obj = this.restApiClient.postApi(builder.toUriString(), null, requestedData, responseType);
            }
            catch (Exception e) {
                regProcLogger.error(LoggerFileConstant.SESSIONID.toString(), LoggerFileConstant.REGISTRATIONID.toString(), "", e.getMessage() + ExceptionUtils.getStackTrace((Throwable)e));
                throw new ApisResourceAccessException(PlatformErrorMessages.RPR_RCT_UNKNOWN_RESOURCE_EXCEPTION.getMessage(), (Throwable)e);
            }
        }
        regProcLogger.debug(LoggerFileConstant.SESSIONID.toString(), LoggerFileConstant.USERID.toString(), "", "RegistrationProcessorRestClientServiceImpl::postApi()::exit");
        return obj;
    }

    public Object postApi(ApiName apiName, MediaType mediaType, List<String> pathsegments, List<String> queryParamName, List<Object> queryParamValue, Object requestedData, Class<?> responseType) throws ApisResourceAccessException {
        regProcLogger.debug(LoggerFileConstant.SESSIONID.toString(), LoggerFileConstant.USERID.toString(), "", "RegistrationProcessorRestClientServiceImpl::postApi()::entry");
        Object obj = null;
        String apiHostIpPort = this.env.getProperty(apiName.name());
        UriComponentsBuilder builder = null;
        if (apiHostIpPort != null) {
            builder = UriComponentsBuilder.fromUriString((String)apiHostIpPort);
        }
        if (builder != null) {
            if (pathsegments != null && !pathsegments.isEmpty()) {
                for (String segment : pathsegments) {
                    if (segment == null || "".equals(segment)) continue;
                    builder.pathSegment(new String[]{segment});
                }
            }
            if (!CollectionUtils.isEmpty(queryParamName)) {
                for (int i = 0; i < queryParamName.size(); ++i) {
                    builder.queryParam(queryParamName.get(i), new Object[]{queryParamValue.get(i)});
                }
            }
            try {
                obj = this.restApiClient.postApi(builder.toUriString(), mediaType, requestedData, responseType);
            }
            catch (Exception e) {
                regProcLogger.error(LoggerFileConstant.SESSIONID.toString(), LoggerFileConstant.REGISTRATIONID.toString(), "", e.getMessage() + ExceptionUtils.getStackTrace((Throwable)e));
                throw new ApisResourceAccessException(PlatformErrorMessages.RPR_RCT_UNKNOWN_RESOURCE_EXCEPTION.getMessage(), (Throwable)e);
            }
        }
        regProcLogger.debug(LoggerFileConstant.SESSIONID.toString(), LoggerFileConstant.USERID.toString(), "", "RegistrationProcessorRestClientServiceImpl::postApi()::exit");
        return obj;
    }

    public Object patchApi(ApiName apiName, List<String> pathsegments, String queryParamName, String queryParamValue, Object requestedData, Class<?> responseType) throws ApisResourceAccessException {
        regProcLogger.debug(LoggerFileConstant.SESSIONID.toString(), LoggerFileConstant.USERID.toString(), "", "RegistrationProcessorRestClientServiceImpl::postApi()::entry");
        Object obj = null;
        String apiHostIpPort = this.env.getProperty(apiName.name());
        UriComponentsBuilder builder = null;
        if (apiHostIpPort != null) {
            builder = UriComponentsBuilder.fromUriString((String)apiHostIpPort);
        }
        if (builder != null) {
            if (pathsegments != null && !pathsegments.isEmpty()) {
                for (String segment : pathsegments) {
                    if (segment == null || "".equals(segment)) continue;
                    builder.pathSegment(new String[]{segment});
                }
            }
            if (!this.checkNull(queryParamName)) {
                String[] queryParamNameArr = queryParamName.split(",");
                String[] queryParamValueArr = queryParamValue.split(",");
                for (int i = 0; i < queryParamNameArr.length; ++i) {
                    builder.queryParam(queryParamNameArr[i], new Object[]{queryParamValueArr[i]});
                }
            }
            try {
                obj = this.restApiClient.patchApi(builder.toUriString(), requestedData, responseType);
            }
            catch (Exception e) {
                regProcLogger.error(LoggerFileConstant.SESSIONID.toString(), LoggerFileConstant.REGISTRATIONID.toString(), "", e.getMessage() + ExceptionUtils.getStackTrace((Throwable)e));
                throw new ApisResourceAccessException(PlatformErrorMessages.RPR_RCT_UNKNOWN_RESOURCE_EXCEPTION.getMessage(), (Throwable)e);
            }
        }
        regProcLogger.debug(LoggerFileConstant.SESSIONID.toString(), LoggerFileConstant.USERID.toString(), "", "RegistrationProcessorRestClientServiceImpl::postApi()::exit");
        return obj;
    }

    public Object putApi(ApiName apiName, List<String> pathsegments, String queryParamName, String queryParamValue, Object requestedData, Class<?> responseType, MediaType mediaType) throws ApisResourceAccessException {
        regProcLogger.debug(LoggerFileConstant.SESSIONID.toString(), LoggerFileConstant.USERID.toString(), "", "RegistrationProcessorRestClientServiceImpl::putApi()::entry");
        Object obj = null;
        String apiHostIpPort = this.env.getProperty(apiName.name());
        UriComponentsBuilder builder = null;
        if (apiHostIpPort != null) {
            builder = UriComponentsBuilder.fromUriString((String)apiHostIpPort);
        }
        if (builder != null) {
            if (pathsegments != null && !pathsegments.isEmpty()) {
                for (String segment : pathsegments) {
                    if (segment == null || "".equals(segment)) continue;
                    builder.pathSegment(new String[]{segment});
                }
            }
            if (!this.checkNull(queryParamName)) {
                String[] queryParamNameArr = queryParamName.split(",");
                String[] queryParamValueArr = queryParamValue.split(",");
                for (int i = 0; i < queryParamNameArr.length; ++i) {
                    builder.queryParam(queryParamNameArr[i], new Object[]{queryParamValueArr[i]});
                }
            }
            try {
                obj = this.restApiClient.putApi(builder.toUriString(), requestedData, responseType, mediaType);
            }
            catch (Exception e) {
                regProcLogger.error(LoggerFileConstant.SESSIONID.toString(), LoggerFileConstant.REGISTRATIONID.toString(), "", e.getMessage() + ExceptionUtils.getStackTrace((Throwable)e));
                throw new ApisResourceAccessException(PlatformErrorMessages.RPR_RCT_UNKNOWN_RESOURCE_EXCEPTION.getMessage(), (Throwable)e);
            }
        }
        regProcLogger.debug(LoggerFileConstant.SESSIONID.toString(), LoggerFileConstant.USERID.toString(), "", "RegistrationProcessorRestClientServiceImpl::putApi()::exit");
        return obj;
    }

    private boolean checkNull(String queryParamName) {
        return queryParamName == null || "".equals(queryParamName);
    }
}

