/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.registration.processor.rest.client.utils;

import com.google.gson.Gson;
import io.mosip.kernel.core.logger.spi.Logger;
import io.mosip.kernel.core.util.DateUtils;
import io.mosip.kernel.core.util.StringUtils;
import io.mosip.kernel.core.util.TokenHandlerUtil;
import io.mosip.registration.processor.core.constant.LoggerFileConstant;
import io.mosip.registration.processor.core.logger.RegProcessorLogger;
import io.mosip.registration.processor.rest.client.audit.dto.Metadata;
import io.mosip.registration.processor.rest.client.audit.dto.PasswordRequest;
import io.mosip.registration.processor.rest.client.audit.dto.SecretKeyRequest;
import io.mosip.registration.processor.rest.client.audit.dto.TokenRequestDTO;
import io.mosip.registration.processor.rest.client.exception.TokenGenerationFailedException;
import java.io.IOException;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class RestApiClient {
    private final Logger logger = RegProcessorLogger.getLogger(RestApiClient.class);
    @Autowired
    RestTemplateBuilder builder;
    @Autowired
    Environment environment;
    private static final String AUTHORIZATION = "Authorization=";

    public <T> T getApi(URI uri, Class<?> responseType) throws Exception {
        Object result = null;
        try {
            RestTemplate restTemplate = this.getRestTemplate();
            result = restTemplate.exchange(uri, HttpMethod.GET, this.setRequestHeader(null, null), responseType).getBody();
        }
        catch (Exception e) {
            this.logger.error(LoggerFileConstant.SESSIONID.toString(), LoggerFileConstant.APPLICATIONID.toString(), LoggerFileConstant.APPLICATIONID.toString(), e.getMessage() + ExceptionUtils.getStackTrace((Throwable)e));
            throw e;
        }
        return (T)result;
    }

    public <T> T postApi(String uri, MediaType mediaType, Object requestType, Class<?> responseClass) throws Exception {
        Object result = null;
        try {
            RestTemplate restTemplate = this.getRestTemplate();
            this.logger.info(LoggerFileConstant.SESSIONID.toString(), LoggerFileConstant.APPLICATIONID.toString(), LoggerFileConstant.APPLICATIONID.toString(), uri);
            result = restTemplate.postForObject(uri, this.setRequestHeader(requestType, mediaType), responseClass, new Object[0]);
        }
        catch (Exception e) {
            this.logger.error(LoggerFileConstant.SESSIONID.toString(), LoggerFileConstant.APPLICATIONID.toString(), LoggerFileConstant.APPLICATIONID.toString(), e.getMessage() + ExceptionUtils.getStackTrace((Throwable)e));
            throw e;
        }
        return (T)result;
    }

    public <T> T patchApi(String uri, MediaType mediaType, Object requestType, Class<?> responseClass) throws Exception {
        Object result = null;
        try {
            RestTemplate restTemplate = this.getRestTemplate();
            this.logger.info(LoggerFileConstant.SESSIONID.toString(), LoggerFileConstant.APPLICATIONID.toString(), LoggerFileConstant.APPLICATIONID.toString(), uri);
            result = restTemplate.patchForObject(uri, this.setRequestHeader(requestType, mediaType), responseClass, new Object[0]);
        }
        catch (Exception e) {
            this.logger.error(LoggerFileConstant.SESSIONID.toString(), LoggerFileConstant.APPLICATIONID.toString(), LoggerFileConstant.APPLICATIONID.toString(), e.getMessage() + ExceptionUtils.getStackTrace((Throwable)e));
            throw e;
        }
        return (T)result;
    }

    public <T> T patchApi(String uri, Object requestType, Class<?> responseClass) throws Exception {
        return this.patchApi(uri, null, requestType, responseClass);
    }

    public <T> T putApi(String uri, Object requestType, Class<?> responseClass, MediaType mediaType) throws Exception {
        Object result = null;
        ResponseEntity response = null;
        try {
            RestTemplate restTemplate = this.getRestTemplate();
            this.logger.info(LoggerFileConstant.SESSIONID.toString(), LoggerFileConstant.APPLICATIONID.toString(), LoggerFileConstant.APPLICATIONID.toString(), uri);
            response = restTemplate.exchange(uri, HttpMethod.PUT, this.setRequestHeader(requestType.toString(), mediaType), responseClass, new Object[0]);
            result = response.getBody();
        }
        catch (Exception e) {
            this.logger.error(LoggerFileConstant.SESSIONID.toString(), LoggerFileConstant.APPLICATIONID.toString(), LoggerFileConstant.APPLICATIONID.toString(), e.getMessage() + ExceptionUtils.getStackTrace((Throwable)e));
            throw e;
        }
        return (T)result;
    }

    public RestTemplate getRestTemplate() throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
        this.logger.info(LoggerFileConstant.SESSIONID.toString(), LoggerFileConstant.APPLICATIONID.toString(), LoggerFileConstant.APPLICATIONID.toString(), Arrays.asList(this.environment.getActiveProfiles()).toString());
        if (Arrays.stream(this.environment.getActiveProfiles()).anyMatch("dev-k8"::equals)) {
            this.logger.info(LoggerFileConstant.SESSIONID.toString(), LoggerFileConstant.APPLICATIONID.toString(), LoggerFileConstant.APPLICATIONID.toString(), Arrays.asList(this.environment.getActiveProfiles()).toString());
            return new RestTemplate();
        }
        TrustStrategy acceptingTrustStrategy = (chain, authType) -> true;
        SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, acceptingTrustStrategy).build();
        SSLConnectionSocketFactory csf = new SSLConnectionSocketFactory(sslContext);
        CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)csf).build();
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory();
        requestFactory.setHttpClient((HttpClient)httpClient);
        return new RestTemplate((ClientHttpRequestFactory)requestFactory);
    }

    private org.springframework.http.HttpEntity<Object> setRequestHeader(Object requestType, MediaType mediaType) throws IOException {
        LinkedMultiValueMap headers = new LinkedMultiValueMap();
        headers.add((Object)"Cookie", (Object)this.getToken());
        if (mediaType != null) {
            headers.add((Object)"Content-Type", (Object)mediaType.toString());
        }
        if (requestType != null) {
            try {
                org.springframework.http.HttpEntity httpEntity = (org.springframework.http.HttpEntity)requestType;
                HttpHeaders httpHeader = httpEntity.getHeaders();
                for (String key : httpHeader.keySet()) {
                    if (headers.containsKey((Object)"Content-Type") && key == "Content-Type") continue;
                    headers.add((Object)key, (Object)((String)httpHeader.get((Object)key).get(0)));
                }
                return new org.springframework.http.HttpEntity(httpEntity.getBody(), (MultiValueMap)headers);
            }
            catch (ClassCastException e) {
                return new org.springframework.http.HttpEntity(requestType, (MultiValueMap)headers);
            }
        }
        return new org.springframework.http.HttpEntity((MultiValueMap)headers);
    }

    public String getToken() throws IOException {
        String token = System.getProperty("token");
        boolean isValid = false;
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            isValid = TokenHandlerUtil.isValidBearerToken((String)token, (String)this.environment.getProperty("token.request.issuerUrl"), (String)this.environment.getProperty("token.request.clientId"));
        }
        if (!isValid) {
            TokenRequestDTO<SecretKeyRequest> tokenRequestDTO = new TokenRequestDTO<SecretKeyRequest>();
            tokenRequestDTO.setId(this.environment.getProperty("token.request.id"));
            tokenRequestDTO.setMetadata(new Metadata());
            tokenRequestDTO.setRequesttime(DateUtils.getUTCCurrentDateTimeString());
            tokenRequestDTO.setRequest(this.setSecretKeyRequestDTO());
            tokenRequestDTO.setVersion(this.environment.getProperty("token.request.version"));
            Gson gson = new Gson();
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            HttpPost post = new HttpPost(this.environment.getProperty("KEYBASEDTOKENAPI"));
            try {
                StringEntity postingString = new StringEntity(gson.toJson(tokenRequestDTO));
                post.setEntity((HttpEntity)postingString);
                post.setHeader("Content-type", "application/json");
                HttpResponse response = httpClient.execute((HttpUriRequest)post);
                HttpEntity entity = response.getEntity();
                String responseBody = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                Header[] cookie = response.getHeaders("Set-Cookie");
                if (cookie.length == 0) {
                    throw new TokenGenerationFailedException();
                }
                token = response.getHeaders("Set-Cookie")[0].getValue();
                System.setProperty("token", token.substring(14, token.indexOf(59)));
                return token.substring(0, token.indexOf(59));
            }
            catch (IOException e) {
                this.logger.error(LoggerFileConstant.SESSIONID.toString(), LoggerFileConstant.APPLICATIONID.toString(), LoggerFileConstant.APPLICATIONID.toString(), e.getMessage() + ExceptionUtils.getStackTrace((Throwable)e));
                throw e;
            }
        }
        return AUTHORIZATION + token;
    }

    private SecretKeyRequest setSecretKeyRequestDTO() {
        SecretKeyRequest request = new SecretKeyRequest();
        request.setAppId(this.environment.getProperty("token.request.appid"));
        request.setClientId(this.environment.getProperty("token.request.clientId"));
        request.setSecretKey(this.environment.getProperty("token.request.secretKey"));
        return request;
    }

    private PasswordRequest setPasswordRequestDTO() {
        PasswordRequest request = new PasswordRequest();
        request.setAppId(this.environment.getProperty("token.request.appid"));
        request.setPassword(this.environment.getProperty("token.request.password"));
        request.setUserName(this.environment.getProperty("token.request.username"));
        return request;
    }
}

