/*
 * Decompiled with CFR 0.152.
 */
package io.mybatis.provider;

import io.mybatis.provider.EntityField;
import io.mybatis.provider.EntityProps;
import io.mybatis.provider.EntityTable;
import io.mybatis.provider.util.Utils;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.UnknownTypeHandler;

public class EntityColumn
extends EntityProps<EntityColumn> {
    protected final EntityField field;
    protected EntityTable entityTable;
    protected String column;
    protected boolean id;
    protected String orderBy;
    protected int orderByPriority;
    protected boolean selectable = true;
    protected boolean insertable = true;
    protected boolean updatable = true;
    protected JdbcType jdbcType;
    protected Class<? extends TypeHandler> typeHandler;
    protected String numericScale;

    protected EntityColumn(EntityField field) {
        this.field = field;
    }

    public static EntityColumn of(EntityField field) {
        return new EntityColumn(field);
    }

    public Class<?> javaType() {
        return this.field().getType();
    }

    public String property() {
        return this.property("");
    }

    public String property(String prefix) {
        return prefix + this.field().getName();
    }

    public String variables() {
        return this.variables("");
    }

    public String variables(String prefix) {
        return "#{" + this.property(prefix) + this.jdbcTypeVariables().orElse("") + this.typeHandlerVariables().orElse("") + this.numericScaleVariables().orElse("") + "}";
    }

    public Optional<String> jdbcTypeVariables() {
        if (this.jdbcType != null && this.jdbcType != JdbcType.UNDEFINED) {
            return Optional.of(", jdbcType=" + this.jdbcType);
        }
        return Optional.empty();
    }

    public Optional<String> typeHandlerVariables() {
        if (this.typeHandler != null && this.typeHandler != UnknownTypeHandler.class) {
            return Optional.of(", typeHandler=" + this.typeHandler.getName());
        }
        return Optional.empty();
    }

    public Optional<String> numericScaleVariables() {
        if (Utils.isNotEmpty(this.numericScale)) {
            return Optional.of(", numericScale=" + this.numericScale);
        }
        return Optional.empty();
    }

    public String columnAsProperty() {
        return this.columnAsProperty("");
    }

    public String columnAsProperty(String prefix) {
        String column = this.column();
        Matcher matcher = EntityTable.DELIMITER.matcher(this.column());
        if (matcher.find()) {
            column = matcher.group(1);
        }
        if (!Objects.equals(column, this.property(prefix))) {
            return this.column() + " AS " + this.property(prefix);
        }
        return this.column();
    }

    public String columnEqualsProperty() {
        return this.columnEqualsProperty("");
    }

    public String columnEqualsProperty(String prefix) {
        return this.column() + " = " + this.variables(prefix);
    }

    public String notNullTest() {
        return this.notNullTest("");
    }

    public String notNullTest(String prefix) {
        return this.property(prefix) + " != null";
    }

    public String notEmptyTest() {
        return this.notEmptyTest("");
    }

    public String notEmptyTest(String prefix) {
        if (this.field().getType() == String.class) {
            return this.notNullTest(prefix) + " and " + this.property(prefix) + " != '' ";
        }
        return this.notNullTest();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EntityColumn)) {
            return false;
        }
        EntityColumn that = (EntityColumn)o;
        return this.column().equals(that.column());
    }

    public int hashCode() {
        return Objects.hash(this.column());
    }

    public String toString() {
        return this.columnEqualsProperty();
    }

    public EntityField field() {
        return this.field;
    }

    public EntityTable entityTable() {
        return this.entityTable;
    }

    public EntityColumn entityTable(EntityTable entityTable) {
        this.entityTable = entityTable;
        return this;
    }

    public String column() {
        return this.column;
    }

    public EntityColumn column(String column) {
        this.column = column;
        return this;
    }

    public boolean id() {
        return this.id;
    }

    public EntityColumn id(boolean id) {
        this.id = id;
        return this;
    }

    public String orderBy() {
        return this.orderBy;
    }

    public EntityColumn orderBy(String orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    public int orderByPriority() {
        return this.orderByPriority;
    }

    public EntityColumn orderByPriority(int orderByPriority) {
        this.orderByPriority = orderByPriority;
        return this;
    }

    public boolean selectable() {
        return this.selectable;
    }

    public EntityColumn selectable(boolean selectable) {
        this.selectable = selectable;
        return this;
    }

    public boolean insertable() {
        return this.insertable;
    }

    public EntityColumn insertable(boolean insertable) {
        this.insertable = insertable;
        return this;
    }

    public boolean updatable() {
        return this.updatable;
    }

    public EntityColumn updatable(boolean updatable) {
        this.updatable = updatable;
        return this;
    }

    public JdbcType jdbcType() {
        return this.jdbcType;
    }

    public EntityColumn jdbcType(JdbcType jdbcType) {
        this.jdbcType = jdbcType;
        return this;
    }

    public Class<? extends TypeHandler> typeHandler() {
        return this.typeHandler;
    }

    public EntityColumn typeHandler(Class<? extends TypeHandler> typeHandler) {
        this.typeHandler = typeHandler;
        return this;
    }

    public String numericScale() {
        return this.numericScale;
    }

    public EntityColumn numericScale(String numericScale) {
        this.numericScale = numericScale;
        return this;
    }
}

