/*
 * Decompiled with CFR 0.152.
 */
package io.nagurea.smsupsdk.campaigns.blacklist.npai;

import io.nagurea.smsupsdk.campaigns.blacklist.npai.BlacklistNPAIResponse;
import io.nagurea.smsupsdk.campaigns.blacklist.npai.BlacklistNPAIResultResponse;
import io.nagurea.smsupsdk.common.exception.RequiredParameterException;
import io.nagurea.smsupsdk.common.http.put.PUTSMSUpService;
import io.nagurea.smsupsdk.helper.json.GsonHelper;
import java.io.IOException;
import java.util.UUID;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class BlacklistNPAIService
extends PUTSMSUpService {
    private static final String URL = "/campaign/%s/npai";
    private static final String ID = "campaign id";

    public BlacklistNPAIService(String rootUrl) {
        super(rootUrl);
    }

    public BlacklistNPAIResponse blacklistNPAI(String token, String id) throws IOException {
        ImmutablePair<Integer, String> response = this.put(this.buildSendUrl(id), token);
        String body = (String)response.getRight();
        BlacklistNPAIResultResponse responseObject = GsonHelper.fromJson(body, BlacklistNPAIResultResponse.class);
        return BlacklistNPAIResponse.builder().uid(UUID.randomUUID().toString()).statusCode((Integer)response.getLeft()).effectiveResponse(responseObject).build();
    }

    private String buildSendUrl(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        RequiredParameterException.RequiredParameterExceptionBuilder exception = RequiredParameterException.builder();
        if (StringUtils.isBlank((CharSequence)id)) {
            exception.requiredParam(ID, id);
            throw exception.build();
        }
        return String.format(URL, id);
    }
}

