/*
 * Decompiled with CFR 0.152.
 */
package io.nagurea.smsupsdk.campaigns.get.campaign;

import io.nagurea.smsupsdk.campaigns.get.campaign.GetCampaignResponse;
import io.nagurea.smsupsdk.campaigns.get.campaign.GetCampaignResultResponse;
import io.nagurea.smsupsdk.common.exception.RequiredParameterException;
import io.nagurea.smsupsdk.common.http.get.GETSMSUpService;
import io.nagurea.smsupsdk.helper.json.GsonHelper;
import java.io.IOException;
import java.util.UUID;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class GetCampaignService
extends GETSMSUpService {
    private static final String URL = "/campaign";
    private static final String ID = "campaign id";

    public GetCampaignService(String rootUrl) {
        super(rootUrl);
    }

    public GetCampaignResponse getCampaign(String token, String id) throws IOException {
        ImmutablePair<Integer, String> response = this.get(this.buildSendUrl(id), token);
        String body = (String)response.getRight();
        GetCampaignResultResponse responseObject = GsonHelper.fromJson(body, GetCampaignResultResponse.class);
        return GetCampaignResponse.builder().uid(UUID.randomUUID().toString()).statusCode((Integer)response.getLeft()).effectiveResponse(responseObject).build();
    }

    private String buildSendUrl(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        RequiredParameterException.RequiredParameterExceptionBuilder exception = RequiredParameterException.builder();
        if (StringUtils.isBlank((CharSequence)id)) {
            exception.requiredParam(ID, id);
            throw exception.build();
        }
        return String.format("%s/%s", URL, id);
    }
}

