/*
 * Decompiled with CFR 0.152.
 */
package io.nagurea.smsupsdk.campaigns.get.history;

import io.nagurea.smsupsdk.campaigns.get.history.GetHistoryResponse;
import io.nagurea.smsupsdk.campaigns.get.history.GetHistoryResultResponse;
import io.nagurea.smsupsdk.campaigns.get.history.HistoryArguments;
import io.nagurea.smsupsdk.common.http.get.GETSMSUpService;
import io.nagurea.smsupsdk.helper.json.GsonHelper;
import java.io.IOException;
import java.util.UUID;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class GetHistoryService
extends GETSMSUpService {
    private static final String URL = "/campaigns";

    public GetHistoryService(String rootUrl) {
        super(rootUrl);
    }

    public GetHistoryResponse getHistoryCampaigns(String token, @NonNull HistoryArguments historyArguments) throws IOException {
        if (historyArguments == null) {
            throw new NullPointerException("historyArguments is marked non-null but is null");
        }
        return this.send(token, historyArguments);
    }

    public GetHistoryResponse getHistoryCampaigns(String token) throws IOException {
        return this.send(token, null);
    }

    private GetHistoryResponse send(String token, HistoryArguments historyArguments) throws IOException {
        ImmutablePair<Integer, String> response = this.get(this.buildSendUrl(historyArguments), token);
        String body = (String)response.getRight();
        GetHistoryResultResponse responseObject = GsonHelper.fromJson(body, GetHistoryResultResponse.class);
        return GetHistoryResponse.builder().uid(UUID.randomUUID().toString()).statusCode((Integer)response.getLeft()).effectiveResponse(responseObject).build();
    }

    private String buildSendUrl(HistoryArguments historyArguments) {
        Object url = URL;
        if (historyArguments != null && historyArguments.hasAtLeastOneArgument()) {
            url = (String)url + historyArguments.toUrl();
        }
        return url;
    }
}

