/*
 * Decompiled with CFR 0.152.
 */
package io.nagurea.smsupsdk.campaigns.get.history;

import com.google.gson.annotations.SerializedName;
import io.nagurea.smsupsdk.common.http.SMSUpURLEncoder;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang3.StringUtils;

public class HistoryArguments {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final String START_NAME = "start";
    private static final String LENGTH_NAME = "length";
    private static final String DATESTART_NAME = "date_start";
    private static final String DATEEND_NAME = "date_end";
    private static final String SMSMIN_NAME = "sms_min";
    private static final String SMSMAX_NAME = "sms_max";
    private final Integer start;
    private final Integer length;
    @SerializedName(value="date_start")
    private final LocalDateTime dateStart;
    @SerializedName(value="date_end")
    private final LocalDateTime dateEnd;
    @SerializedName(value="sms_min")
    private final Integer smsMin;
    @SerializedName(value="sms_max")
    private final Integer smsMax;

    public boolean hasAtLeastOneArgument() {
        return this.start != null || this.length != null || this.dateStart != null || this.dateEnd != null || this.smsMin != null || this.smsMax != null;
    }

    public String toUrl() {
        Object url = "";
        url = (String)url + this.addArgument((String)url, START_NAME, this.start);
        url = (String)url + this.addArgument((String)url, LENGTH_NAME, this.length);
        url = (String)url + this.addArgument((String)url, DATESTART_NAME, this.dateStart);
        url = (String)url + this.addArgument((String)url, DATEEND_NAME, this.dateEnd);
        url = (String)url + this.addArgument((String)url, SMSMIN_NAME, this.smsMin);
        url = (String)url + this.addArgument((String)url, SMSMAX_NAME, this.smsMax);
        return url;
    }

    private String addArgument(String url, String parameterName, Integer parameterValue) {
        String stringParameterValue = "";
        if (parameterValue != null) {
            stringParameterValue = parameterValue.toString();
        }
        return this.addArgument(url, parameterName, stringParameterValue);
    }

    private String addArgument(String url, String parameterName, LocalDateTime parameterValue) {
        String stringParameterValue = "";
        if (parameterValue != null) {
            stringParameterValue = parameterValue.format(DATE_TIME_FORMATTER);
        }
        return this.addArgument(url, parameterName, stringParameterValue);
    }

    private String addArgument(String url, String parameterName, String parameterValue) {
        Object urlPartStart = "";
        if (StringUtils.isNotEmpty((CharSequence)parameterValue)) {
            urlPartStart = "".equals(url) ? (String)urlPartStart + "?" : "&";
            return (String)urlPartStart + parameterName + "=" + SMSUpURLEncoder.encode(parameterValue);
        }
        return "";
    }

    HistoryArguments(Integer start, Integer length, LocalDateTime dateStart, LocalDateTime dateEnd, Integer smsMin, Integer smsMax) {
        this.start = start;
        this.length = length;
        this.dateStart = dateStart;
        this.dateEnd = dateEnd;
        this.smsMin = smsMin;
        this.smsMax = smsMax;
    }

    public static HistoryArgumentsBuilder builder() {
        return new HistoryArgumentsBuilder();
    }

    public Integer getStart() {
        return this.start;
    }

    public Integer getLength() {
        return this.length;
    }

    public LocalDateTime getDateStart() {
        return this.dateStart;
    }

    public LocalDateTime getDateEnd() {
        return this.dateEnd;
    }

    public Integer getSmsMin() {
        return this.smsMin;
    }

    public Integer getSmsMax() {
        return this.smsMax;
    }

    public static class HistoryArgumentsBuilder {
        private Integer start;
        private Integer length;
        private LocalDateTime dateStart;
        private LocalDateTime dateEnd;
        private Integer smsMin;
        private Integer smsMax;

        HistoryArgumentsBuilder() {
        }

        public HistoryArgumentsBuilder start(Integer start) {
            this.start = start;
            return this;
        }

        public HistoryArgumentsBuilder length(Integer length) {
            this.length = length;
            return this;
        }

        public HistoryArgumentsBuilder dateStart(LocalDateTime dateStart) {
            this.dateStart = dateStart;
            return this;
        }

        public HistoryArgumentsBuilder dateEnd(LocalDateTime dateEnd) {
            this.dateEnd = dateEnd;
            return this;
        }

        public HistoryArgumentsBuilder smsMin(Integer smsMin) {
            this.smsMin = smsMin;
            return this;
        }

        public HistoryArgumentsBuilder smsMax(Integer smsMax) {
            this.smsMax = smsMax;
            return this;
        }

        public HistoryArguments build() {
            return new HistoryArguments(this.start, this.length, this.dateStart, this.dateEnd, this.smsMin, this.smsMax);
        }

        public String toString() {
            return "HistoryArguments.HistoryArgumentsBuilder(start=" + this.start + ", length=" + this.length + ", dateStart=" + this.dateStart + ", dateEnd=" + this.dateEnd + ", smsMin=" + this.smsMin + ", smsMax=" + this.smsMax + ")";
        }
    }
}

