/*
 * Decompiled with CFR 0.152.
 */
package io.nagurea.smsupsdk.common;

import io.nagurea.smsupsdk.common.exception.ContentLengthException;
import io.nagurea.smsupsdk.common.http.HTTPMethod;
import io.nagurea.smsupsdk.common.response.PDFDocument;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

public abstract class SMSUpService {
    protected static final String TEXT = "text";
    private final String rootUrl;

    protected abstract HTTPMethod getHttpMethod();

    protected String read(InputStream is) throws IOException {
        BufferedReader in = null;
        try {
            String inputLine;
            in = new BufferedReader(new InputStreamReader(is));
            StringBuilder body = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                body.append(inputLine);
            }
            in.close();
            String string = body.toString();
            this.closeQuietly(in);
            return string;
        }
        catch (IOException ioe) {
            try {
                throw ioe;
            }
            catch (Throwable throwable) {
                this.closeQuietly(in);
                throw throwable;
            }
        }
    }

    protected PDFDocument readPDF(InputStream is, int contentLength, String fileName) throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            byte[] bytes = is.readAllBytes();
            if (contentLength != bytes.length) {
                throw ContentLengthException.newContentLengthException(contentLength, bytes.length);
            }
            out.write(bytes);
            PDFDocument pDFDocument = PDFDocument.builder().filename(fileName).documentOutputStream(out).build();
            return pDFDocument;
        }
    }

    protected void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getRootUrl() {
        return this.rootUrl;
    }

    protected HttpURLConnection getHttpURLConnectionWithBearer(String token, URL url) throws IOException {
        HttpURLConnection con = this.initiateConnection(token, url);
        con.setRequestProperty("Accept", "application/json");
        return con;
    }

    protected HttpURLConnection getPDFFileConnectionWithBearer(String token, URL url) throws IOException {
        HttpURLConnection con = this.initiateConnection(token, url);
        con.setRequestProperty("Accept", "application/pdf");
        return con;
    }

    private HttpURLConnection initiateConnection(String token, URL url) throws IOException {
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestMethod(this.getHttpMethod().toString());
        con.setRequestProperty("Authorization", "Bearer " + token);
        return con;
    }

    protected SMSUpService(String rootUrl) {
        this.rootUrl = rootUrl;
    }
}

