/*
 * Decompiled with CFR 0.152.
 */
package io.nagurea.smsupsdk.common.exception;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class RequiredParameterException
extends RuntimeException {
    private final Map<String, Object> requiredParams;

    @Override
    public String getMessage() {
        return this.requiredParams.entrySet().stream().map(e -> String.format("%s is required but has value '%s'", e.getKey(), e.getValue() == null ? "null" : e.getValue().toString())).collect(Collectors.joining(System.lineSeparator()));
    }

    RequiredParameterException(Map<String, Object> requiredParams) {
        this.requiredParams = requiredParams;
    }

    public static RequiredParameterExceptionBuilder builder() {
        return new RequiredParameterExceptionBuilder();
    }

    public static class RequiredParameterExceptionBuilder {
        private ArrayList<String> requiredParams$key;
        private ArrayList<Object> requiredParams$value;

        RequiredParameterExceptionBuilder() {
        }

        public RequiredParameterExceptionBuilder requiredParam(String requiredParamKey, Object requiredParamValue) {
            if (this.requiredParams$key == null) {
                this.requiredParams$key = new ArrayList();
                this.requiredParams$value = new ArrayList();
            }
            this.requiredParams$key.add(requiredParamKey);
            this.requiredParams$value.add(requiredParamValue);
            return this;
        }

        public RequiredParameterExceptionBuilder requiredParams(Map<? extends String, ? extends Object> requiredParams) {
            if (requiredParams == null) {
                throw new NullPointerException("requiredParams cannot be null");
            }
            if (this.requiredParams$key == null) {
                this.requiredParams$key = new ArrayList();
                this.requiredParams$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : requiredParams.entrySet()) {
                this.requiredParams$key.add($lombokEntry.getKey());
                this.requiredParams$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public RequiredParameterExceptionBuilder clearRequiredParams() {
            if (this.requiredParams$key != null) {
                this.requiredParams$key.clear();
                this.requiredParams$value.clear();
            }
            return this;
        }

        public RequiredParameterException build() {
            Map<String, Object> requiredParams;
            switch (this.requiredParams$key == null ? 0 : this.requiredParams$key.size()) {
                case 0: {
                    requiredParams = Collections.emptyMap();
                    break;
                }
                case 1: {
                    requiredParams = Collections.singletonMap(this.requiredParams$key.get(0), this.requiredParams$value.get(0));
                    break;
                }
                default: {
                    requiredParams = new LinkedHashMap<String, Object>(this.requiredParams$key.size() < 0x40000000 ? 1 + this.requiredParams$key.size() + (this.requiredParams$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.requiredParams$key.size(); ++$i) {
                        requiredParams.put(this.requiredParams$key.get($i), this.requiredParams$value.get($i));
                    }
                    requiredParams = Collections.unmodifiableMap(requiredParams);
                }
            }
            return new RequiredParameterException(requiredParams);
        }

        public String toString() {
            return "RequiredParameterException.RequiredParameterExceptionBuilder(requiredParams$key=" + this.requiredParams$key + ", requiredParams$value=" + this.requiredParams$value + ")";
        }
    }
}

