/*
 * Decompiled with CFR 0.152.
 */
package io.nagurea.smsupsdk.common.http.get;

import io.nagurea.smsupsdk.common.SMSUpService;
import io.nagurea.smsupsdk.common.http.HTTPMethod;
import io.nagurea.smsupsdk.common.response.PDFDocument;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class GETSMSUpService
extends SMSUpService {
    protected GETSMSUpService(String rootUrl) {
        super(rootUrl);
    }

    @Override
    protected HTTPMethod getHttpMethod() {
        return HTTPMethod.GET;
    }

    protected ImmutablePair<Integer, String> get(String getUrl, String token) throws IOException {
        URL url = new URL(this.getRootUrl() + getUrl);
        HttpURLConnection con = this.getHttpURLConnectionWithBearer(token, url);
        return new ImmutablePair((Object)con.getResponseCode(), (Object)this.read(con.getInputStream()));
    }

    protected ImmutablePair<Integer, PDFDocument> getPDF(String getUrl, String token) throws IOException {
        URL url = new URL(this.getRootUrl() + getUrl);
        HttpURLConnection con = this.getHttpURLConnectionWithBearer(token, url);
        int responseCode = con.getResponseCode();
        if (responseCode == 200) {
            Object fileName = "";
            String disposition = con.getHeaderField("Content-Disposition");
            String contentType = con.getContentType();
            if (!"application/pdf".equals(contentType)) {
                throw new NotImplementedException(contentType + " is not yet implemented");
            }
            int contentLength = con.getContentLength();
            if (disposition != null) {
                int index = disposition.indexOf("filename=");
                if (index > -1) {
                    fileName = disposition.substring(index + 10, disposition.length() - 1);
                }
            } else {
                fileName = "noFilenameFoundInContentDispositionHeader-" + LocalDateTime.now().toEpochSecond(ZoneOffset.UTC);
            }
            return new ImmutablePair((Object)con.getResponseCode(), (Object)this.readPDF(con.getInputStream(), contentLength, (String)fileName));
        }
        return new ImmutablePair((Object)con.getResponseCode(), null);
    }
}

