/*
 * Decompiled with CFR 0.152.
 */
package io.nagurea.smsupsdk.common.http.put;

import io.nagurea.smsupsdk.common.SMSUpService;
import io.nagurea.smsupsdk.common.http.HTTPMethod;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class PUTSMSUpService
extends SMSUpService {
    protected PUTSMSUpService(String rootUrl) {
        super(rootUrl);
    }

    @Override
    protected HTTPMethod getHttpMethod() {
        return HTTPMethod.PUT;
    }

    protected ImmutablePair<Integer, String> put(String postUrl, String token) throws IOException {
        URL url = new URL(this.getRootUrl() + postUrl);
        HttpURLConnection con = this.getHttpURLConnectionWithBearer(token, url);
        con.setDoOutput(true);
        return new ImmutablePair((Object)con.getResponseCode(), (Object)this.read(con.getInputStream()));
    }

    protected ImmutablePair<Integer, String> put(String postUrl, String token, @NonNull String data) throws IOException {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        URL url = new URL(this.getRootUrl() + postUrl);
        HttpURLConnection con = this.getHttpURLConnectionWithBearer(token, url);
        con.setDoOutput(true);
        this.sendData(con, data);
        return new ImmutablePair((Object)con.getResponseCode(), (Object)this.read(con.getInputStream()));
    }

    protected void sendData(HttpURLConnection con, String data) throws IOException {
        try (OutputStream os = con.getOutputStream();){
            byte[] input = data.getBytes(StandardCharsets.UTF_8);
            os.write(input, 0, input.length);
        }
    }
}

