/*
 * Decompiled with CFR 0.152.
 */
package io.nagurea.smsupsdk.common.response;

import io.nagurea.smsupsdk.common.response.Document;
import io.nagurea.smsupsdk.helper.MD5Helper;
import java.io.ByteArrayOutputStream;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class PDFDocument
extends Document<ByteArrayOutputStream> {
    private final String filename;

    public PDFDocument(ByteArrayOutputStream documentOutputStream, String filename) {
        super(documentOutputStream);
        this.filename = filename;
    }

    @Override
    public String toString() {
        return "PDFDocument{documentOutputStream=" + MD5Helper.md5sum((ByteArrayOutputStream)this.documentOutputStream) + ", filename='" + this.filename + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PDFDocument that = (PDFDocument)o;
        return new EqualsBuilder().append((Object)this.filename, (Object)that.filename).append((Object)MD5Helper.md5sum((ByteArrayOutputStream)this.documentOutputStream), (Object)MD5Helper.md5sum((ByteArrayOutputStream)that.documentOutputStream)).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.filename).append((Object)MD5Helper.md5sum((ByteArrayOutputStream)this.documentOutputStream)).toHashCode();
    }

    public static PDFDocumentBuilder builder() {
        return new PDFDocumentBuilder();
    }

    public String getFilename() {
        return this.filename;
    }

    public static class PDFDocumentBuilder {
        private ByteArrayOutputStream documentOutputStream;
        private String filename;

        PDFDocumentBuilder() {
        }

        public PDFDocumentBuilder documentOutputStream(ByteArrayOutputStream documentOutputStream) {
            this.documentOutputStream = documentOutputStream;
            return this;
        }

        public PDFDocumentBuilder filename(String filename) {
            this.filename = filename;
            return this;
        }

        public PDFDocument build() {
            return new PDFDocument(this.documentOutputStream, this.filename);
        }

        public String toString() {
            return "PDFDocument.PDFDocumentBuilder(documentOutputStream=" + this.documentOutputStream + ", filename=" + this.filename + ")";
        }
    }
}

