/*
 * Decompiled with CFR 0.152.
 */
package io.nagurea.smsupsdk.contacts.deduplicate;

import com.google.gson.Gson;
import io.nagurea.smsupsdk.common.exception.RequiredParameterException;
import io.nagurea.smsupsdk.common.http.put.PUTSMSUpService;
import io.nagurea.smsupsdk.contacts.deduplicate.DeduplicateResponse;
import io.nagurea.smsupsdk.contacts.deduplicate.DeduplicateResultResponse;
import java.io.IOException;
import java.util.UUID;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class DeduplicateService
extends PUTSMSUpService {
    private static final String URL = "/list/deduplicate/%s";
    private static final String ID = "list id";

    public DeduplicateService(String rootUrl) {
        super(rootUrl);
    }

    public DeduplicateResponse deduplicate(@NonNull String token, @NonNull String id) throws IOException {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        ImmutablePair<Integer, String> response = this.put(this.buildUrl(id), token);
        DeduplicateResultResponse responseObject = (DeduplicateResultResponse)new Gson().fromJson((String)response.getRight(), DeduplicateResultResponse.class);
        return DeduplicateResponse.builder().uid(UUID.randomUUID().toString()).statusCode((Integer)response.getLeft()).effectiveResponse(responseObject).build();
    }

    private String buildUrl(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        RequiredParameterException.RequiredParameterExceptionBuilder exception = RequiredParameterException.builder();
        if (StringUtils.isBlank((CharSequence)id)) {
            exception.requiredParam(ID, id);
            throw exception.build();
        }
        return String.format(URL, id);
    }
}

