/*
 * Decompiled with CFR 0.152.
 */
package io.nagurea.smsupsdk.contacts.remove;

import io.nagurea.smsupsdk.common.exception.RequiredParameterException;
import io.nagurea.smsupsdk.common.http.delete.DELETESMSUpService;
import io.nagurea.smsupsdk.contacts.remove.RemoveContactResponse;
import io.nagurea.smsupsdk.contacts.remove.RemoveContactResultResponse;
import io.nagurea.smsupsdk.helper.json.GsonHelper;
import java.io.IOException;
import java.util.UUID;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class RemoveContactService
extends DELETESMSUpService {
    private static final String URL = "/list/contact";
    private static final String ID = "contact id";

    public RemoveContactService(String rootUrl) {
        super(rootUrl);
    }

    public RemoveContactResponse removeContact(String token, String id) throws IOException {
        ImmutablePair<Integer, String> response = this.delete(this.buildSendUrl(id), token);
        String body = (String)response.getRight();
        RemoveContactResultResponse responseObject = GsonHelper.fromJson(body, RemoveContactResultResponse.class);
        return RemoveContactResponse.builder().uid(UUID.randomUUID().toString()).statusCode((Integer)response.getLeft()).effectiveResponse(responseObject).build();
    }

    private String buildSendUrl(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        RequiredParameterException.RequiredParameterExceptionBuilder exception = RequiredParameterException.builder();
        if (StringUtils.isBlank((CharSequence)id)) {
            exception.requiredParam(ID, id);
            throw exception.build();
        }
        return String.format("%s/%s", URL, id);
    }
}

