/*
 * Decompiled with CFR 0.152.
 */
package io.nagurea.smsupsdk.contacts.update;

import io.nagurea.smsupsdk.common.exception.RequiredParameterException;
import io.nagurea.smsupsdk.common.http.put.PUTSMSUpService;
import io.nagurea.smsupsdk.contacts.update.UpdateContactResponse;
import io.nagurea.smsupsdk.contacts.update.UpdateContactResultResponse;
import io.nagurea.smsupsdk.contacts.update.body.ContactBody;
import io.nagurea.smsupsdk.helper.json.GsonHelper;
import java.io.IOException;
import java.util.UUID;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class UpdateContactService
extends PUTSMSUpService {
    private static final String URL = "/list/contact/%s";
    private static final String ID = "contact id";

    public UpdateContactService(String rootUrl) {
        super(rootUrl);
    }

    public UpdateContactResponse updateContact(@NonNull String token, @NonNull String id, @NonNull ContactBody contactBody) throws IOException {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (contactBody == null) {
            throw new NullPointerException("contactBody is marked non-null but is null");
        }
        ImmutablePair<Integer, String> response = this.put(this.buildUrl(id), token, GsonHelper.toJson(contactBody));
        UpdateContactResultResponse responseObject = GsonHelper.fromJson((String)response.getRight(), UpdateContactResultResponse.class);
        return UpdateContactResponse.builder().uid(UUID.randomUUID().toString()).statusCode((Integer)response.getLeft()).effectiveResponse(responseObject).build();
    }

    private String buildUrl(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        RequiredParameterException.RequiredParameterExceptionBuilder exception = RequiredParameterException.builder();
        if (StringUtils.isBlank((CharSequence)id)) {
            exception.requiredParam(ID, id);
            throw exception.build();
        }
        return String.format(URL, id);
    }
}

