/*
 * Decompiled with CFR 0.152.
 */
package io.nagurea.smsupsdk.invoices.get;

import com.google.gson.annotations.SerializedName;
import io.nagurea.smsupsdk.invoices.get.Product;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class Invoice {
    private final String id;
    private final String name;
    private final LocalDateTime creation;
    private final LocalDateTime validation;
    private final String price;
    private final String vat;
    private final String total;
    private final String currency;
    private final String status;
    @SerializedName(value="payment_type")
    private final String paymentType;
    private final List<Product> products;

    Invoice(String id, String name, LocalDateTime creation, LocalDateTime validation, String price, String vat, String total, String currency, String status, String paymentType, List<Product> products) {
        this.id = id;
        this.name = name;
        this.creation = creation;
        this.validation = validation;
        this.price = price;
        this.vat = vat;
        this.total = total;
        this.currency = currency;
        this.status = status;
        this.paymentType = paymentType;
        this.products = products;
    }

    public static InvoiceBuilder builder() {
        return new InvoiceBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public LocalDateTime getCreation() {
        return this.creation;
    }

    public LocalDateTime getValidation() {
        return this.validation;
    }

    public String getPrice() {
        return this.price;
    }

    public String getVat() {
        return this.vat;
    }

    public String getTotal() {
        return this.total;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getStatus() {
        return this.status;
    }

    public String getPaymentType() {
        return this.paymentType;
    }

    public List<Product> getProducts() {
        return this.products;
    }

    public String toString() {
        return "Invoice(id=" + this.getId() + ", name=" + this.getName() + ", creation=" + this.getCreation() + ", validation=" + this.getValidation() + ", price=" + this.getPrice() + ", vat=" + this.getVat() + ", total=" + this.getTotal() + ", currency=" + this.getCurrency() + ", status=" + this.getStatus() + ", paymentType=" + this.getPaymentType() + ", products=" + this.getProducts() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Invoice)) {
            return false;
        }
        Invoice other = (Invoice)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        LocalDateTime this$creation = this.getCreation();
        LocalDateTime other$creation = other.getCreation();
        if (this$creation == null ? other$creation != null : !((Object)this$creation).equals(other$creation)) {
            return false;
        }
        LocalDateTime this$validation = this.getValidation();
        LocalDateTime other$validation = other.getValidation();
        if (this$validation == null ? other$validation != null : !((Object)this$validation).equals(other$validation)) {
            return false;
        }
        String this$price = this.getPrice();
        String other$price = other.getPrice();
        if (this$price == null ? other$price != null : !this$price.equals(other$price)) {
            return false;
        }
        String this$vat = this.getVat();
        String other$vat = other.getVat();
        if (this$vat == null ? other$vat != null : !this$vat.equals(other$vat)) {
            return false;
        }
        String this$total = this.getTotal();
        String other$total = other.getTotal();
        if (this$total == null ? other$total != null : !this$total.equals(other$total)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$paymentType = this.getPaymentType();
        String other$paymentType = other.getPaymentType();
        if (this$paymentType == null ? other$paymentType != null : !this$paymentType.equals(other$paymentType)) {
            return false;
        }
        List<Product> this$products = this.getProducts();
        List<Product> other$products = other.getProducts();
        return !(this$products == null ? other$products != null : !((Object)this$products).equals(other$products));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Invoice;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        LocalDateTime $creation = this.getCreation();
        result = result * 59 + ($creation == null ? 43 : ((Object)$creation).hashCode());
        LocalDateTime $validation = this.getValidation();
        result = result * 59 + ($validation == null ? 43 : ((Object)$validation).hashCode());
        String $price = this.getPrice();
        result = result * 59 + ($price == null ? 43 : $price.hashCode());
        String $vat = this.getVat();
        result = result * 59 + ($vat == null ? 43 : $vat.hashCode());
        String $total = this.getTotal();
        result = result * 59 + ($total == null ? 43 : $total.hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $paymentType = this.getPaymentType();
        result = result * 59 + ($paymentType == null ? 43 : $paymentType.hashCode());
        List<Product> $products = this.getProducts();
        result = result * 59 + ($products == null ? 43 : ((Object)$products).hashCode());
        return result;
    }

    public static class InvoiceBuilder {
        private String id;
        private String name;
        private LocalDateTime creation;
        private LocalDateTime validation;
        private String price;
        private String vat;
        private String total;
        private String currency;
        private String status;
        private String paymentType;
        private ArrayList<Product> products;

        InvoiceBuilder() {
        }

        public InvoiceBuilder id(String id) {
            this.id = id;
            return this;
        }

        public InvoiceBuilder name(String name) {
            this.name = name;
            return this;
        }

        public InvoiceBuilder creation(LocalDateTime creation) {
            this.creation = creation;
            return this;
        }

        public InvoiceBuilder validation(LocalDateTime validation) {
            this.validation = validation;
            return this;
        }

        public InvoiceBuilder price(String price) {
            this.price = price;
            return this;
        }

        public InvoiceBuilder vat(String vat) {
            this.vat = vat;
            return this;
        }

        public InvoiceBuilder total(String total) {
            this.total = total;
            return this;
        }

        public InvoiceBuilder currency(String currency) {
            this.currency = currency;
            return this;
        }

        public InvoiceBuilder status(String status) {
            this.status = status;
            return this;
        }

        public InvoiceBuilder paymentType(String paymentType) {
            this.paymentType = paymentType;
            return this;
        }

        public InvoiceBuilder product(Product product) {
            if (this.products == null) {
                this.products = new ArrayList();
            }
            this.products.add(product);
            return this;
        }

        public InvoiceBuilder products(Collection<? extends Product> products) {
            if (products == null) {
                throw new NullPointerException("products cannot be null");
            }
            if (this.products == null) {
                this.products = new ArrayList();
            }
            this.products.addAll(products);
            return this;
        }

        public InvoiceBuilder clearProducts() {
            if (this.products != null) {
                this.products.clear();
            }
            return this;
        }

        public Invoice build() {
            List<Product> products;
            switch (this.products == null ? 0 : this.products.size()) {
                case 0: {
                    products = Collections.emptyList();
                    break;
                }
                case 1: {
                    products = Collections.singletonList(this.products.get(0));
                    break;
                }
                default: {
                    products = Collections.unmodifiableList(new ArrayList<Product>(this.products));
                }
            }
            return new Invoice(this.id, this.name, this.creation, this.validation, this.price, this.vat, this.total, this.currency, this.status, this.paymentType, products);
        }

        public String toString() {
            return "Invoice.InvoiceBuilder(id=" + this.id + ", name=" + this.name + ", creation=" + this.creation + ", validation=" + this.validation + ", price=" + this.price + ", vat=" + this.vat + ", total=" + this.total + ", currency=" + this.currency + ", status=" + this.status + ", paymentType=" + this.paymentType + ", products=" + this.products + ")";
        }
    }
}

