/*
 * Decompiled with CFR 0.152.
 */
package io.nagurea.smsupsdk.invoices.get;

import com.google.gson.annotations.SerializedName;

public class Product {
    private final String description;
    @SerializedName(value="unit_price")
    private final String unitPrice;
    private final String quantities;
    private final String price;

    Product(String description, String unitPrice, String quantities, String price) {
        this.description = description;
        this.unitPrice = unitPrice;
        this.quantities = quantities;
        this.price = price;
    }

    public static ProductBuilder builder() {
        return new ProductBuilder();
    }

    public String getDescription() {
        return this.description;
    }

    public String getUnitPrice() {
        return this.unitPrice;
    }

    public String getQuantities() {
        return this.quantities;
    }

    public String getPrice() {
        return this.price;
    }

    public String toString() {
        return "Product(description=" + this.getDescription() + ", unitPrice=" + this.getUnitPrice() + ", quantities=" + this.getQuantities() + ", price=" + this.getPrice() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Product)) {
            return false;
        }
        Product other = (Product)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$unitPrice = this.getUnitPrice();
        String other$unitPrice = other.getUnitPrice();
        if (this$unitPrice == null ? other$unitPrice != null : !this$unitPrice.equals(other$unitPrice)) {
            return false;
        }
        String this$quantities = this.getQuantities();
        String other$quantities = other.getQuantities();
        if (this$quantities == null ? other$quantities != null : !this$quantities.equals(other$quantities)) {
            return false;
        }
        String this$price = this.getPrice();
        String other$price = other.getPrice();
        return !(this$price == null ? other$price != null : !this$price.equals(other$price));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Product;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $unitPrice = this.getUnitPrice();
        result = result * 59 + ($unitPrice == null ? 43 : $unitPrice.hashCode());
        String $quantities = this.getQuantities();
        result = result * 59 + ($quantities == null ? 43 : $quantities.hashCode());
        String $price = this.getPrice();
        result = result * 59 + ($price == null ? 43 : $price.hashCode());
        return result;
    }

    public static class ProductBuilder {
        private String description;
        private String unitPrice;
        private String quantities;
        private String price;

        ProductBuilder() {
        }

        public ProductBuilder description(String description) {
            this.description = description;
            return this;
        }

        public ProductBuilder unitPrice(String unitPrice) {
            this.unitPrice = unitPrice;
            return this;
        }

        public ProductBuilder quantities(String quantities) {
            this.quantities = quantities;
            return this;
        }

        public ProductBuilder price(String price) {
            this.price = price;
            return this;
        }

        public Product build() {
            return new Product(this.description, this.unitPrice, this.quantities, this.price);
        }

        public String toString() {
            return "Product.ProductBuilder(description=" + this.description + ", unitPrice=" + this.unitPrice + ", quantities=" + this.quantities + ", price=" + this.price + ")";
        }
    }
}

