/*
 * Decompiled with CFR 0.152.
 */
package io.nagurea.smsupsdk.lists.clear;

import com.google.gson.Gson;
import io.nagurea.smsupsdk.common.exception.RequiredParameterException;
import io.nagurea.smsupsdk.common.http.put.PUTSMSUpService;
import io.nagurea.smsupsdk.lists.clear.ClearListResponse;
import io.nagurea.smsupsdk.lists.clear.ClearListResultResponse;
import java.io.IOException;
import java.util.UUID;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class ClearListService
extends PUTSMSUpService {
    private static final String URL = "/list/%s/npai/clear";
    private static final String ID = "list id";

    public ClearListService(String rootUrl) {
        super(rootUrl);
    }

    public ClearListResponse clear(@NonNull String token, @NonNull String id) throws IOException {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        ImmutablePair<Integer, String> response = this.put(this.buildUrl(id), token);
        ClearListResultResponse responseObject = (ClearListResultResponse)new Gson().fromJson((String)response.getRight(), ClearListResultResponse.class);
        return ClearListResponse.builder().uid(UUID.randomUUID().toString()).statusCode((Integer)response.getLeft()).effectiveResponse(responseObject).build();
    }

    private String buildUrl(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        RequiredParameterException.RequiredParameterExceptionBuilder exception = RequiredParameterException.builder();
        if (StringUtils.isBlank((CharSequence)id)) {
            exception.requiredParam(ID, id);
            throw exception.build();
        }
        return String.format(URL, id);
    }
}

