/*
 * Decompiled with CFR 0.152.
 */
package io.nagurea.smsupsdk.lists.create;

import com.google.gson.Gson;
import io.nagurea.smsupsdk.common.http.post.POSTSMSUpService;
import io.nagurea.smsupsdk.helper.json.GsonHelper;
import io.nagurea.smsupsdk.lists.create.CreateListResponse;
import io.nagurea.smsupsdk.lists.create.CreateListResultResponse;
import io.nagurea.smsupsdk.lists.create.arguments.CreateListArguments;
import io.nagurea.smsupsdk.lists.create.body.ContactList;
import io.nagurea.smsupsdk.lists.create.body.CreateListBody;
import java.io.IOException;
import java.util.UUID;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class CreateListService
extends POSTSMSUpService {
    private static final String URL = "/list";

    public CreateListService(String rootUrl) {
        super(rootUrl);
    }

    public CreateListResponse create(@NonNull String token, @NonNull CreateListArguments createListArguments) throws IOException {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (createListArguments == null) {
            throw new NullPointerException("createListArguments is marked non-null but is null");
        }
        createListArguments.checkContacts();
        ImmutablePair<Integer, String> response = this.post(URL, token, this.buildData(createListArguments));
        CreateListResultResponse responseObject = (CreateListResultResponse)new Gson().fromJson((String)response.getRight(), CreateListResultResponse.class);
        return CreateListResponse.builder().uid(UUID.randomUUID().toString()).statusCode((Integer)response.getLeft()).effectiveResponse(responseObject).build();
    }

    private String buildData(CreateListArguments createListArguments) {
        CreateListBody createListBody = CreateListBody.builder().list(ContactList.builder().name(createListArguments.getName()).contacts(createListArguments.getContacts()).build()).build();
        return GsonHelper.toJson(createListBody);
    }
}

