/*
 * Decompiled with CFR 0.152.
 */
package io.nagurea.smsupsdk.lists.create.arguments;

import io.nagurea.smsupsdk.lists.create.body.Contacts;
import lombok.NonNull;

public class CreateListArguments {
    private final String name;
    @NonNull
    private final Contacts contacts;

    public void checkContacts() {
        this.contacts.check();
    }

    CreateListArguments(String name, @NonNull Contacts contacts) {
        if (contacts == null) {
            throw new NullPointerException("contacts is marked non-null but is null");
        }
        this.name = name;
        this.contacts = contacts;
    }

    public static CreateListArgumentsBuilder builder() {
        return new CreateListArgumentsBuilder();
    }

    public String getName() {
        return this.name;
    }

    @NonNull
    public Contacts getContacts() {
        return this.contacts;
    }

    public static class CreateListArgumentsBuilder {
        private String name;
        private Contacts contacts;

        CreateListArgumentsBuilder() {
        }

        public CreateListArgumentsBuilder name(String name) {
            this.name = name;
            return this;
        }

        public CreateListArgumentsBuilder contacts(@NonNull Contacts contacts) {
            if (contacts == null) {
                throw new NullPointerException("contacts is marked non-null but is null");
            }
            this.contacts = contacts;
            return this;
        }

        public CreateListArguments build() {
            return new CreateListArguments(this.name, this.contacts);
        }

        public String toString() {
            return "CreateListArguments.CreateListArgumentsBuilder(name=" + this.name + ", contacts=" + this.contacts + ")";
        }
    }
}

