/*
 * Decompiled with CFR 0.152.
 */
package io.nagurea.smsupsdk.lists.create.body;

import io.nagurea.smsupsdk.lists.create.body.Gsm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;

public class Contacts {
    @NonNull
    private final List<Gsm> gsm;

    public void check() {
        this.gsm.forEach(Gsm::check);
    }

    Contacts(@NonNull List<Gsm> gsm) {
        if (gsm == null) {
            throw new NullPointerException("gsm is marked non-null but is null");
        }
        this.gsm = gsm;
    }

    public static ContactsBuilder builder() {
        return new ContactsBuilder();
    }

    @NonNull
    public List<Gsm> getGsm() {
        return this.gsm;
    }

    public static class ContactsBuilder {
        private ArrayList<Gsm> gsm;

        ContactsBuilder() {
        }

        public ContactsBuilder gsm(Gsm gsm) {
            if (this.gsm == null) {
                this.gsm = new ArrayList();
            }
            this.gsm.add(gsm);
            return this;
        }

        public ContactsBuilder gsm(Collection<? extends Gsm> gsm) {
            if (gsm == null) {
                throw new NullPointerException("gsm cannot be null");
            }
            if (this.gsm == null) {
                this.gsm = new ArrayList();
            }
            this.gsm.addAll(gsm);
            return this;
        }

        public ContactsBuilder clearGsm() {
            if (this.gsm != null) {
                this.gsm.clear();
            }
            return this;
        }

        public Contacts build() {
            List<Gsm> gsm;
            switch (this.gsm == null ? 0 : this.gsm.size()) {
                case 0: {
                    gsm = Collections.emptyList();
                    break;
                }
                case 1: {
                    gsm = Collections.singletonList(this.gsm.get(0));
                    break;
                }
                default: {
                    gsm = Collections.unmodifiableList(new ArrayList<Gsm>(this.gsm));
                }
            }
            return new Contacts(gsm);
        }

        public String toString() {
            return "Contacts.ContactsBuilder(gsm=" + this.gsm + ")";
        }
    }
}

