/*
 * Decompiled with CFR 0.152.
 */
package io.nagurea.smsupsdk.lists.delete;

import io.nagurea.smsupsdk.common.exception.RequiredParameterException;
import io.nagurea.smsupsdk.common.http.delete.DELETESMSUpService;
import io.nagurea.smsupsdk.helper.json.GsonHelper;
import io.nagurea.smsupsdk.lists.delete.DeleteListResponse;
import io.nagurea.smsupsdk.lists.delete.DeleteListResultResponse;
import java.io.IOException;
import java.util.UUID;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class DeleteListService
extends DELETESMSUpService {
    private static final String URL = "/list";
    private static final String ID = "list id";

    public DeleteListService(String rootUrl) {
        super(rootUrl);
    }

    public DeleteListResponse deleteList(String token, String id) throws IOException {
        ImmutablePair<Integer, String> response = this.delete(this.buildSendUrl(id), token);
        String body = (String)response.getRight();
        DeleteListResultResponse responseObject = GsonHelper.fromJson(body, DeleteListResultResponse.class);
        return DeleteListResponse.builder().uid(UUID.randomUUID().toString()).statusCode((Integer)response.getLeft()).effectiveResponse(responseObject).build();
    }

    private String buildSendUrl(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        RequiredParameterException.RequiredParameterExceptionBuilder exception = RequiredParameterException.builder();
        if (StringUtils.isBlank((CharSequence)id)) {
            exception.requiredParam(ID, id);
            throw exception.build();
        }
        return String.format("%s/%s", URL, id);
    }
}

