/*
 * Decompiled with CFR 0.152.
 */
package io.nagurea.smsupsdk.lists.npai;

import io.nagurea.smsupsdk.common.response.ResultResponse;
import io.nagurea.smsupsdk.common.status.ResponseStatus;
import io.nagurea.smsupsdk.lists.npai.NPAIContact;
import java.util.List;

public class NPAIResultResponse
extends ResultResponse {
    private final List<NPAIContact> list;
    private final Integer totalRecords;
    private final Integer totalDisplayRecords;

    public NPAIResultResponse(ResponseStatus responseStatus, String message, List<NPAIContact> list, Integer totalRecords, Integer totalDisplayRecords) {
        super(responseStatus, message);
        this.list = list;
        this.totalRecords = totalRecords;
        this.totalDisplayRecords = totalDisplayRecords;
    }

    public static NPAIResultResponseBuilder builder() {
        return new NPAIResultResponseBuilder();
    }

    @Override
    public String toString() {
        return "NPAIResultResponse(list=" + this.getList() + ", totalRecords=" + this.getTotalRecords() + ", totalDisplayRecords=" + this.getTotalDisplayRecords() + ")";
    }

    public List<NPAIContact> getList() {
        return this.list;
    }

    public Integer getTotalRecords() {
        return this.totalRecords;
    }

    public Integer getTotalDisplayRecords() {
        return this.totalDisplayRecords;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NPAIResultResponse)) {
            return false;
        }
        NPAIResultResponse other = (NPAIResultResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$totalRecords = this.getTotalRecords();
        Integer other$totalRecords = other.getTotalRecords();
        if (this$totalRecords == null ? other$totalRecords != null : !((Object)this$totalRecords).equals(other$totalRecords)) {
            return false;
        }
        Integer this$totalDisplayRecords = this.getTotalDisplayRecords();
        Integer other$totalDisplayRecords = other.getTotalDisplayRecords();
        if (this$totalDisplayRecords == null ? other$totalDisplayRecords != null : !((Object)this$totalDisplayRecords).equals(other$totalDisplayRecords)) {
            return false;
        }
        List<NPAIContact> this$list = this.getList();
        List<NPAIContact> other$list = other.getList();
        return !(this$list == null ? other$list != null : !((Object)this$list).equals(other$list));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof NPAIResultResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $totalRecords = this.getTotalRecords();
        result = result * 59 + ($totalRecords == null ? 43 : ((Object)$totalRecords).hashCode());
        Integer $totalDisplayRecords = this.getTotalDisplayRecords();
        result = result * 59 + ($totalDisplayRecords == null ? 43 : ((Object)$totalDisplayRecords).hashCode());
        List<NPAIContact> $list = this.getList();
        result = result * 59 + ($list == null ? 43 : ((Object)$list).hashCode());
        return result;
    }

    public static class NPAIResultResponseBuilder {
        private ResponseStatus responseStatus;
        private String message;
        private List<NPAIContact> list;
        private Integer totalRecords;
        private Integer totalDisplayRecords;

        NPAIResultResponseBuilder() {
        }

        public NPAIResultResponseBuilder responseStatus(ResponseStatus responseStatus) {
            this.responseStatus = responseStatus;
            return this;
        }

        public NPAIResultResponseBuilder message(String message) {
            this.message = message;
            return this;
        }

        public NPAIResultResponseBuilder list(List<NPAIContact> list) {
            this.list = list;
            return this;
        }

        public NPAIResultResponseBuilder totalRecords(Integer totalRecords) {
            this.totalRecords = totalRecords;
            return this;
        }

        public NPAIResultResponseBuilder totalDisplayRecords(Integer totalDisplayRecords) {
            this.totalDisplayRecords = totalDisplayRecords;
            return this;
        }

        public NPAIResultResponse build() {
            return new NPAIResultResponse(this.responseStatus, this.message, this.list, this.totalRecords, this.totalDisplayRecords);
        }

        public String toString() {
            return "NPAIResultResponse.NPAIResultResponseBuilder(responseStatus=" + this.responseStatus + ", message=" + this.message + ", list=" + this.list + ", totalRecords=" + this.totalRecords + ", totalDisplayRecords=" + this.totalDisplayRecords + ")";
        }
    }
}

