/*
 * Decompiled with CFR 0.152.
 */
package io.nagurea.smsupsdk.sendsms.arguments;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import lombok.NonNull;

public class Delay {
    private final String value;

    public String toString() {
        return this.value;
    }

    Delay(String value) {
        this.value = value;
    }

    public static DelayBuilder builder() {
        return new DelayBuilder();
    }

    public String getValue() {
        return this.value;
    }

    public static class DelayBuilder {
        private String value;
        private static final DateTimeFormatter DELAY_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd hh:mm:ss");

        public DelayBuilder value(@NonNull LocalDateTime delay) {
            if (delay == null) {
                throw new NullPointerException("delay is marked non-null but is null");
            }
            this.value = delay.format(DELAY_FORMATTER);
            return this;
        }

        public DelayBuilder value() {
            this.value(LocalDateTime.now());
            return this;
        }

        DelayBuilder() {
        }

        public Delay build() {
            return new Delay(this.value);
        }

        public String toString() {
            return "Delay.DelayBuilder(value=" + this.value + ")";
        }
    }
}

