/*
 * Decompiled with CFR 0.152.
 */
package io.nagurea.smsupsdk.sendsms.arguments;

import io.nagurea.smsupsdk.common.http.SMSUpURLEncoder;
import io.nagurea.smsupsdk.sendsms.arguments.Delay;
import io.nagurea.smsupsdk.sendsms.arguments.PushType;
import io.nagurea.smsupsdk.sendsms.sender.NoSender;
import io.nagurea.smsupsdk.sendsms.sender.Sender;
import org.apache.commons.lang3.StringUtils;

public abstract class OptionalArguments {
    private static final String PUSH_TYPE_NAME = "pushType";
    private static final String DELAY_NAME = "delay";
    private static final String SENDER_NAME = "sender";
    private static final String GSMSMSID_NAME = "gsmsmsid";
    private final PushType pushType;
    private final Delay delay;
    private Sender sender = NoSender.build();
    private final String gsmsmsid;
    private int unicode = 0;

    public boolean hasAtLeastOneArgument() {
        return this.delay != null || this.sender.whoSent().isPresent() || StringUtils.isNotEmpty((CharSequence)this.gsmsmsid);
    }

    public String toUrl() {
        Object url = "";
        url = (String)url + this.addArgument(PUSH_TYPE_NAME, this.pushType.getLabel());
        url = (String)url + this.addArgument(DELAY_NAME, this.delay == null ? "" : this.delay.toString());
        url = (String)url + this.addArgument(SENDER_NAME, this.sender.whoSent().orElse(null));
        url = (String)url + this.addArgument(GSMSMSID_NAME, this.gsmsmsid);
        return url;
    }

    private String addArgument(String parameterName, String parameterValue) {
        if (StringUtils.isNotEmpty((CharSequence)parameterValue)) {
            return "&" + parameterName + "=" + SMSUpURLEncoder.encode(parameterValue);
        }
        return "";
    }

    public OptionalArguments(PushType pushType, Delay delay, Sender sender, String gsmsmsid, int unicode) {
        this.pushType = pushType;
        this.delay = delay;
        this.sender = sender;
        this.gsmsmsid = gsmsmsid;
        this.unicode = unicode;
    }

    public PushType getPushType() {
        return this.pushType;
    }

    public Delay getDelay() {
        return this.delay;
    }

    public Sender getSender() {
        return this.sender;
    }

    public String getGsmsmsid() {
        return this.gsmsmsid;
    }

    public int getUnicode() {
        return this.unicode;
    }
}

