/*
 * Decompiled with CFR 0.152.
 */
package io.nagurea.smsupsdk.sendsms.campaign;

import io.nagurea.smsupsdk.common.http.post.POSTSMSUpService;
import io.nagurea.smsupsdk.helper.json.GsonHelper;
import io.nagurea.smsupsdk.sendsms.arguments.AlertOptionalArguments;
import io.nagurea.smsupsdk.sendsms.arguments.MarketingOptionalArguments;
import io.nagurea.smsupsdk.sendsms.arguments.OptionalArguments;
import io.nagurea.smsupsdk.sendsms.campaign.CampaignResponse;
import io.nagurea.smsupsdk.sendsms.campaign.CampaignResultResponse;
import io.nagurea.smsupsdk.sendsms.campaign.body.CampaignDataBuilder;
import io.nagurea.smsupsdk.sendsms.campaign.body.Recipients;
import io.nagurea.smsupsdk.sendsms.sender.NoSender;
import java.io.IOException;
import java.util.UUID;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class CampaignService
extends POSTSMSUpService {
    private static final String URL = "/send";

    public CampaignService(String rootUrl) {
        super(rootUrl);
    }

    public CampaignResponse sendAlert(String token, String text, Recipients recipients) throws IOException {
        return this.send(token, text, recipients, AlertOptionalArguments.builder().sender(NoSender.build()).build());
    }

    public CampaignResponse sendAlert(String token, String text, Recipients recipients, @NonNull AlertOptionalArguments alertOptionalArgument) throws IOException {
        if (alertOptionalArgument == null) {
            throw new NullPointerException("alertOptionalArgument is marked non-null but is null");
        }
        return this.send(token, text, recipients, alertOptionalArgument);
    }

    public CampaignResponse sendMarketing(String token, String text, Recipients recipients) throws IOException {
        return this.send(token, text, recipients, MarketingOptionalArguments.builder().sender(NoSender.build()).build());
    }

    public CampaignResponse sendMarketing(String token, String text, Recipients recipients, @NonNull MarketingOptionalArguments marketingOptionalArguments) throws IOException {
        if (marketingOptionalArguments == null) {
            throw new NullPointerException("marketingOptionalArguments is marked non-null but is null");
        }
        return this.send(token, text, recipients, marketingOptionalArguments);
    }

    private CampaignResponse send(String token, String text, Recipients recipients, @NonNull OptionalArguments optionalArguments) throws IOException {
        if (optionalArguments == null) {
            throw new NullPointerException("optionalArguments is marked non-null but is null");
        }
        recipients.check();
        ImmutablePair<Integer, String> response = this.post(URL, token, CampaignDataBuilder.builder().text(text).optionalArguments(optionalArguments).build().buildData());
        CampaignResultResponse responseObject = GsonHelper.fromJson((String)response.getRight(), CampaignResultResponse.class);
        return CampaignResponse.builder().uid(UUID.randomUUID().toString()).statusCode((Integer)response.getLeft()).effectiveResponse(responseObject).build();
    }
}

