/*
 * Decompiled with CFR 0.152.
 */
package io.nagurea.smsupsdk.sendsms.campaignwithlist;

import io.nagurea.smsupsdk.common.http.post.POSTSMSUpService;
import io.nagurea.smsupsdk.helper.json.GsonHelper;
import io.nagurea.smsupsdk.sendsms.arguments.AlertOptionalArguments;
import io.nagurea.smsupsdk.sendsms.arguments.MarketingOptionalArguments;
import io.nagurea.smsupsdk.sendsms.arguments.OptionalArguments;
import io.nagurea.smsupsdk.sendsms.campaignwithlist.CampaignWithListResponse;
import io.nagurea.smsupsdk.sendsms.campaignwithlist.CampaignWithListResultResponse;
import io.nagurea.smsupsdk.sendsms.campaignwithlist.body.CampaignWithListDataBuilder;
import io.nagurea.smsupsdk.sendsms.campaignwithlist.body.ListId;
import io.nagurea.smsupsdk.sendsms.sender.NoSender;
import java.io.IOException;
import java.util.Set;
import java.util.UUID;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class CampaignWithListService
extends POSTSMSUpService {
    private static final String URL = "/send/lists";
    private static final String SIMULATE_URL = "/simulate";

    public CampaignWithListService(String rootUrl) {
        super(rootUrl);
    }

    public CampaignWithListResponse sendAlert(String token, String text, Set<ListId> lists) throws IOException {
        return this.send(false, token, text, lists, AlertOptionalArguments.builder().sender(NoSender.build()).build());
    }

    public CampaignWithListResponse simulateSendAlert(String token, String text, Set<ListId> lists) throws IOException {
        return this.send(true, token, text, lists, AlertOptionalArguments.builder().sender(NoSender.build()).build());
    }

    public CampaignWithListResponse sendAlert(String token, String text, Set<ListId> lists, @NonNull AlertOptionalArguments alertOptionalArgument) throws IOException {
        if (alertOptionalArgument == null) {
            throw new NullPointerException("alertOptionalArgument is marked non-null but is null");
        }
        return this.send(false, token, text, lists, alertOptionalArgument);
    }

    public CampaignWithListResponse simulateSendAlert(String token, String text, Set<ListId> lists, @NonNull AlertOptionalArguments alertOptionalArgument) throws IOException {
        if (alertOptionalArgument == null) {
            throw new NullPointerException("alertOptionalArgument is marked non-null but is null");
        }
        return this.send(true, token, text, lists, alertOptionalArgument);
    }

    public CampaignWithListResponse sendMarketing(String token, String text, Set<ListId> lists) throws IOException {
        return this.send(false, token, text, lists, MarketingOptionalArguments.builder().sender(NoSender.build()).build());
    }

    public CampaignWithListResponse simulateSendMarketing(String token, String text, Set<ListId> lists) throws IOException {
        return this.send(true, token, text, lists, MarketingOptionalArguments.builder().sender(NoSender.build()).build());
    }

    public CampaignWithListResponse sendMarketing(String token, String text, Set<ListId> lists, @NonNull MarketingOptionalArguments marketingOptionalArguments) throws IOException {
        if (marketingOptionalArguments == null) {
            throw new NullPointerException("marketingOptionalArguments is marked non-null but is null");
        }
        return this.send(false, token, text, lists, marketingOptionalArguments);
    }

    public CampaignWithListResponse simulateSendMarketing(String token, String text, Set<ListId> lists, @NonNull MarketingOptionalArguments marketingOptionalArguments) throws IOException {
        if (marketingOptionalArguments == null) {
            throw new NullPointerException("marketingOptionalArguments is marked non-null but is null");
        }
        return this.send(true, token, text, lists, marketingOptionalArguments);
    }

    private CampaignWithListResponse send(boolean simulate, String token, String text, Set<ListId> lists, @NonNull OptionalArguments optionalArguments) throws IOException {
        if (optionalArguments == null) {
            throw new NullPointerException("optionalArguments is marked non-null but is null");
        }
        ImmutablePair<Integer, String> response = this.post(this.buildUrl(simulate), token, CampaignWithListDataBuilder.builder().text(text).lists(lists).optionalArguments(optionalArguments).build().buildData());
        CampaignWithListResultResponse responseObject = GsonHelper.fromJson((String)response.getRight(), CampaignWithListResultResponse.class);
        return CampaignWithListResponse.builder().uid(UUID.randomUUID().toString()).statusCode((Integer)response.getLeft()).effectiveResponse(responseObject).build();
    }

    private String buildUrl(boolean simulate) {
        return URL + (simulate ? SIMULATE_URL : "");
    }
}

