/*
 * Decompiled with CFR 0.152.
 */
package io.nagurea.smsupsdk.sendsms.cancelcampaign;

import io.nagurea.smsupsdk.common.exception.RequiredParameterException;
import io.nagurea.smsupsdk.common.http.delete.DELETESMSUpService;
import io.nagurea.smsupsdk.helper.json.GsonHelper;
import io.nagurea.smsupsdk.sendsms.cancelcampaign.CancelCampaignResponse;
import io.nagurea.smsupsdk.sendsms.cancelcampaign.CancelCampaignResultResponse;
import java.io.IOException;
import java.util.UUID;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class CancelCampaignService
extends DELETESMSUpService {
    private static final String URL = "/send";
    private static final String ID = "campaign id";

    public CancelCampaignService(String rootUrl) {
        super(rootUrl);
    }

    public CancelCampaignResponse cancel(String token, String id) throws IOException {
        ImmutablePair<Integer, String> response = this.delete(this.buildSendUrl(id), token);
        String body = (String)response.getRight();
        CancelCampaignResultResponse responseObject = GsonHelper.fromJson(body, CancelCampaignResultResponse.class);
        return CancelCampaignResponse.builder().uid(UUID.randomUUID().toString()).statusCode((Integer)response.getLeft()).effectiveResponse(responseObject).build();
    }

    private String buildSendUrl(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        RequiredParameterException.RequiredParameterExceptionBuilder exception = RequiredParameterException.builder();
        if (StringUtils.isBlank((CharSequence)id)) {
            exception.requiredParam(ID, id);
            throw exception.build();
        }
        return String.format("%s/%s", URL, id);
    }
}

